/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketChanged;
import com.robothy.s3.core.annotations.BucketReadLock;
import com.robothy.s3.core.annotations.BucketWriteLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;

public interface BucketEncryptionService
extends LocalS3MetadataApplicable {
    @BucketChanged
    @BucketWriteLock
    default public void putBucketEncryption(String bucketName, String encryption) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        bucketMetadata.setEncryption(encryption);
    }

    @BucketReadLock
    default public String getBucketEncryption(String bucketName) {
        return BucketAssertions.assertBucketEncryptionExist(this.localS3Metadata(), bucketName);
    }

    @BucketChanged
    @BucketWriteLock
    default public void deleteBucketEncryption(String bucketName) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        bucketMetadata.setEncryption(null);
    }
}

