/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketChanged;
import com.robothy.s3.core.annotations.BucketReadLock;
import com.robothy.s3.core.annotations.BucketWriteLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;
import com.robothy.s3.datatypes.AccessControlPolicy;
import com.robothy.s3.datatypes.Owner;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public interface BucketAclService
extends LocalS3MetadataApplicable {
    @BucketChanged
    @BucketWriteLock
    default public void putBucketAcl(String bucketName, AccessControlPolicy acl) {
        BucketAssertions.assertBucketNameIsValid(bucketName);
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        bucketMetadata.setAcl(acl);
    }

    @BucketReadLock
    default public AccessControlPolicy getBucketAcl(String bucketName) {
        BucketAssertions.assertBucketNameIsValid(bucketName);
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(this.localS3Metadata(), bucketName);
        Owner defaultOwner = new Owner("LocalS3", "001");
        Optional<AccessControlPolicy> aclOpt = bucketMetadata.getAcl();
        if (aclOpt.isEmpty()) {
            return AccessControlPolicy.builder().owner(defaultOwner).grants(Collections.emptyList()).build();
        }
        AccessControlPolicy acl = aclOpt.get();
        if (Objects.isNull(acl.getOwner())) {
            acl.setOwner(defaultOwner);
        }
        if (Objects.isNull(acl.getGrants())) {
            acl.setGrants(Collections.emptyList());
        }
        return acl;
    }
}

