/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.service;

import com.robothy.s3.core.annotations.BucketChanged;
import com.robothy.s3.core.annotations.BucketWriteLock;
import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.asserionts.ObjectAssertions;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.model.internal.LocalS3Metadata;
import com.robothy.s3.core.model.internal.UploadMetadata;
import com.robothy.s3.core.service.LocalS3MetadataApplicable;
import com.robothy.s3.core.service.StorageApplicable;
import java.util.NavigableMap;

public interface AbortMultipartUploadService
extends LocalS3MetadataApplicable,
StorageApplicable {
    @BucketChanged
    @BucketWriteLock
    default public void abortMultipartUpload(String bucketName, String objectKey, String uploadId) {
        LocalS3Metadata s3Metadata = this.localS3Metadata();
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(s3Metadata, bucketName);
        ObjectAssertions.assertObjectKeyIsValid(objectKey);
        NavigableMap<String, NavigableMap<String, UploadMetadata>> uploads = bucketMetadata.getUploads();
        if (!uploads.containsKey(objectKey) || !((NavigableMap)uploads.get(objectKey)).containsKey(uploadId)) {
            return;
        }
        UploadMetadata uploadMetadata = (UploadMetadata)((NavigableMap)uploads.get(objectKey)).remove(uploadId);
        uploadMetadata.getParts().forEach((uploadNumber, part) -> this.storage().delete(part.getFileId()));
        uploadMetadata.getParts().clear();
    }
}

