/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.model.request;

import java.io.InputStream;
import java.util.Optional;

public class UploadPartOptions {
    private long contentLength;
    private InputStream data;
    private String etag;

    public Optional<String> getETag() {
        return Optional.ofNullable(this.etag);
    }

    UploadPartOptions(long contentLength, InputStream data, String etag) {
        this.contentLength = contentLength;
        this.data = data;
        this.etag = etag;
    }

    public static UploadPartOptionsBuilder builder() {
        return new UploadPartOptionsBuilder();
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public InputStream getData() {
        return this.data;
    }

    public static class UploadPartOptionsBuilder {
        private long contentLength;
        private InputStream data;
        private String etag;

        UploadPartOptionsBuilder() {
        }

        public UploadPartOptionsBuilder contentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public UploadPartOptionsBuilder data(InputStream data) {
            this.data = data;
            return this;
        }

        public UploadPartOptionsBuilder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public UploadPartOptions build() {
            return new UploadPartOptions(this.contentLength, this.data, this.etag);
        }

        public String toString() {
            return "UploadPartOptions.UploadPartOptionsBuilder(contentLength=" + this.contentLength + ", data=" + this.data + ", etag=" + this.etag + ")";
        }
    }
}

