/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.model.request;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

public class PutObjectOptions {
    private String contentType;
    private long size;
    private InputStream content;
    private String[][] tagging;
    private Map<String, String> userMetadata;

    public Optional<String[][]> getTagging() {
        return Optional.ofNullable(this.tagging);
    }

    PutObjectOptions(String contentType, long size, InputStream content, String[][] tagging, Map<String, String> userMetadata) {
        this.contentType = contentType;
        this.size = size;
        this.content = content;
        this.tagging = tagging;
        this.userMetadata = userMetadata;
    }

    public static PutObjectOptionsBuilder builder() {
        return new PutObjectOptionsBuilder();
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getSize() {
        return this.size;
    }

    public InputStream getContent() {
        return this.content;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PutObjectOptions)) {
            return false;
        }
        PutObjectOptions other = (PutObjectOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        Optional<String[][]> this$tagging = this.getTagging();
        Optional<String[][]> other$tagging = other.getTagging();
        if (this$tagging == null ? other$tagging != null : !((Object)this$tagging).equals(other$tagging)) {
            return false;
        }
        Map<String, String> this$userMetadata = this.getUserMetadata();
        Map<String, String> other$userMetadata = other.getUserMetadata();
        return !(this$userMetadata == null ? other$userMetadata != null : !((Object)this$userMetadata).equals(other$userMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PutObjectOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        Optional<String[][]> $tagging = this.getTagging();
        result = result * 59 + ($tagging == null ? 43 : ((Object)$tagging).hashCode());
        Map<String, String> $userMetadata = this.getUserMetadata();
        result = result * 59 + ($userMetadata == null ? 43 : ((Object)$userMetadata).hashCode());
        return result;
    }

    public static class PutObjectOptionsBuilder {
        private String contentType;
        private long size;
        private InputStream content;
        private String[][] tagging;
        private Map<String, String> userMetadata;

        PutObjectOptionsBuilder() {
        }

        public PutObjectOptionsBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public PutObjectOptionsBuilder size(long size) {
            this.size = size;
            return this;
        }

        public PutObjectOptionsBuilder content(InputStream content) {
            this.content = content;
            return this;
        }

        public PutObjectOptionsBuilder tagging(String[][] tagging) {
            this.tagging = tagging;
            return this;
        }

        public PutObjectOptionsBuilder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = userMetadata;
            return this;
        }

        public PutObjectOptions build() {
            return new PutObjectOptions(this.contentType, this.size, this.content, this.tagging, this.userMetadata);
        }

        public String toString() {
            return "PutObjectOptions.PutObjectOptionsBuilder(contentType=" + this.contentType + ", size=" + this.size + ", content=" + this.content + ", tagging=" + Arrays.deepToString((Object[])this.tagging) + ", userMetadata=" + this.userMetadata + ")";
        }
    }
}

