/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.model.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.robothy.s3.core.converters.deserializer.VersionedObjectMetadataMapConverter;
import com.robothy.s3.core.model.internal.VersionedObjectMetadata;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;

public class ObjectMetadata {
    public static final String NULL_VERSION = "null";
    @JsonDeserialize(converter=VersionedObjectMetadataMapConverter.class)
    private ConcurrentSkipListMap<String, VersionedObjectMetadata> versionedObjectMap = new ConcurrentSkipListMap(Comparator.reverseOrder());
    private String virtualVersion;

    public ObjectMetadata(String version, VersionedObjectMetadata firstVersion) {
        this.putVersionedObjectMetadata(version, firstVersion);
    }

    public ObjectMetadata() {
    }

    public Optional<VersionedObjectMetadata> getVersionedObjectMetadata(String versionId) {
        return Optional.ofNullable(this.versionedObjectMap.get(versionId));
    }

    public void putVersionedObjectMetadata(String versionId, VersionedObjectMetadata versionedObjectMetadata) {
        this.versionedObjectMap.put(versionId, versionedObjectMetadata);
    }

    @JsonIgnore
    public VersionedObjectMetadata getLatest() {
        return this.versionedObjectMap.firstEntry().getValue();
    }

    @JsonIgnore
    public String getLatestVersion() {
        return this.versionedObjectMap.firstKey();
    }

    public Optional<String> getVirtualVersion() {
        return Optional.ofNullable(this.virtualVersion);
    }

    public ConcurrentSkipListMap<String, VersionedObjectMetadata> getVersionedObjectMap() {
        return this.versionedObjectMap;
    }

    @JsonDeserialize(converter=VersionedObjectMetadataMapConverter.class)
    public void setVersionedObjectMap(ConcurrentSkipListMap<String, VersionedObjectMetadata> versionedObjectMap) {
        this.versionedObjectMap = versionedObjectMap;
    }

    public void setVirtualVersion(String virtualVersion) {
        this.virtualVersion = virtualVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectMetadata)) {
            return false;
        }
        ObjectMetadata other = (ObjectMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConcurrentSkipListMap<String, VersionedObjectMetadata> this$versionedObjectMap = this.getVersionedObjectMap();
        ConcurrentSkipListMap<String, VersionedObjectMetadata> other$versionedObjectMap = other.getVersionedObjectMap();
        if (this$versionedObjectMap == null ? other$versionedObjectMap != null : !((Object)this$versionedObjectMap).equals(other$versionedObjectMap)) {
            return false;
        }
        Optional<String> this$virtualVersion = this.getVirtualVersion();
        Optional<String> other$virtualVersion = other.getVirtualVersion();
        return !(this$virtualVersion == null ? other$virtualVersion != null : !((Object)this$virtualVersion).equals(other$virtualVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObjectMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConcurrentSkipListMap<String, VersionedObjectMetadata> $versionedObjectMap = this.getVersionedObjectMap();
        result = result * 59 + ($versionedObjectMap == null ? 43 : ((Object)$versionedObjectMap).hashCode());
        Optional<String> $virtualVersion = this.getVirtualVersion();
        result = result * 59 + ($virtualVersion == null ? 43 : ((Object)$virtualVersion).hashCode());
        return result;
    }

    public String toString() {
        return "ObjectMetadata(versionedObjectMap=" + this.getVersionedObjectMap() + ", virtualVersion=" + this.getVirtualVersion() + ")";
    }
}

