/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.model.internal;

import com.robothy.s3.core.asserionts.BucketAssertions;
import com.robothy.s3.core.model.internal.BucketMetadata;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class LocalS3Metadata {
    public static final long VERSION = 1L;
    private static final Comparator<BucketMetadata> DEFAULT_BUCKET_METADATA_COMPARATOR = Comparator.comparing(BucketMetadata::getCreationDate);
    private final Map<String, BucketMetadata> bucketMetadataMap = new ConcurrentHashMap<String, BucketMetadata>();

    public List<BucketMetadata> listBuckets(Comparator<BucketMetadata> comparator) {
        ArrayList<BucketMetadata> bucketList = new ArrayList<BucketMetadata>(this.bucketMetadataMap.values());
        bucketList.sort(comparator);
        return bucketList;
    }

    public List<BucketMetadata> listBuckets() {
        return this.listBuckets(DEFAULT_BUCKET_METADATA_COMPARATOR);
    }

    public Map<String, BucketMetadata> getBucketMetadataMap() {
        return this.bucketMetadataMap;
    }

    public Optional<BucketMetadata> getBucketMetadata(String bucketName) {
        return Optional.ofNullable(this.bucketMetadataMap.get(bucketName));
    }

    public void addBucketMetadata(BucketMetadata bucketMetadata) {
        BucketAssertions.assertBucketNotExists(this, bucketMetadata.getBucketName());
        this.bucketMetadataMap.put(bucketMetadata.getBucketName(), bucketMetadata);
    }
}

