/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.model.internal;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.robothy.s3.core.asserionts.ObjectAssertions;
import com.robothy.s3.core.converters.deserializer.ObjectMetadataMapConverter;
import com.robothy.s3.core.converters.deserializer.UploadMetadataMapConverter;
import com.robothy.s3.core.model.internal.ObjectMetadata;
import com.robothy.s3.core.model.internal.UploadMetadata;
import com.robothy.s3.datatypes.AccessControlPolicy;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;

public class BucketMetadata {
    @JsonDeserialize(converter=ObjectMetadataMapConverter.class)
    private ConcurrentSkipListMap<String, ObjectMetadata> objectMap = new ConcurrentSkipListMap();
    private long creationDate;
    private String region;
    @JsonDeserialize(converter=UploadMetadataMapConverter.class)
    private NavigableMap<String, NavigableMap<String, UploadMetadata>> uploads = new ConcurrentSkipListMap<String, NavigableMap<String, UploadMetadata>>();
    private Boolean versioningEnabled;
    private String bucketName;
    private Collection<Map<String, String>> tagging;
    private AccessControlPolicy acl;
    private String policy;
    private String replication;
    private String encryption;

    public Optional<ObjectMetadata> getObjectMetadata(String key) {
        return Optional.ofNullable(this.objectMap.get(key));
    }

    public ObjectMetadata putObjectMetadata(String key, ObjectMetadata objectMetadata) {
        ObjectAssertions.assertObjectKeyIsValid(key);
        this.objectMap.put(key, objectMetadata);
        return objectMetadata;
    }

    public Optional<Collection<Map<String, String>>> getTagging() {
        return Optional.ofNullable(this.tagging);
    }

    public void setTagging(Collection<Map<String, String>> tagging) {
        this.tagging = tagging;
    }

    public Optional<AccessControlPolicy> getAcl() {
        return Optional.ofNullable(this.acl);
    }

    public void setAcl(AccessControlPolicy acl) {
        this.acl = acl;
    }

    public Optional<String> getPolicy() {
        return Optional.ofNullable(this.policy);
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public Optional<String> getReplication() {
        return Optional.ofNullable(this.replication);
    }

    public void setReplication(String replication) {
        this.replication = replication;
    }

    public Optional<String> getEncryption() {
        return Optional.ofNullable(this.encryption);
    }

    public void setEncryption(String encryption) {
        this.encryption = encryption;
    }

    public ConcurrentSkipListMap<String, ObjectMetadata> getObjectMap() {
        return this.objectMap;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public String getRegion() {
        return this.region;
    }

    public NavigableMap<String, NavigableMap<String, UploadMetadata>> getUploads() {
        return this.uploads;
    }

    public Boolean getVersioningEnabled() {
        return this.versioningEnabled;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    @JsonDeserialize(converter=ObjectMetadataMapConverter.class)
    public void setObjectMap(ConcurrentSkipListMap<String, ObjectMetadata> objectMap) {
        this.objectMap = objectMap;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @JsonDeserialize(converter=UploadMetadataMapConverter.class)
    public void setUploads(NavigableMap<String, NavigableMap<String, UploadMetadata>> uploads) {
        this.uploads = uploads;
    }

    public void setVersioningEnabled(Boolean versioningEnabled) {
        this.versioningEnabled = versioningEnabled;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BucketMetadata)) {
            return false;
        }
        BucketMetadata other = (BucketMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreationDate() != other.getCreationDate()) {
            return false;
        }
        Boolean this$versioningEnabled = this.getVersioningEnabled();
        Boolean other$versioningEnabled = other.getVersioningEnabled();
        if (this$versioningEnabled == null ? other$versioningEnabled != null : !((Object)this$versioningEnabled).equals(other$versioningEnabled)) {
            return false;
        }
        ConcurrentSkipListMap<String, ObjectMetadata> this$objectMap = this.getObjectMap();
        ConcurrentSkipListMap<String, ObjectMetadata> other$objectMap = other.getObjectMap();
        if (this$objectMap == null ? other$objectMap != null : !((Object)this$objectMap).equals(other$objectMap)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        NavigableMap<String, NavigableMap<String, UploadMetadata>> this$uploads = this.getUploads();
        NavigableMap<String, NavigableMap<String, UploadMetadata>> other$uploads = other.getUploads();
        if (this$uploads == null ? other$uploads != null : !this$uploads.equals(other$uploads)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        Optional<Collection<Map<String, String>>> this$tagging = this.getTagging();
        Optional<Collection<Map<String, String>>> other$tagging = other.getTagging();
        if (this$tagging == null ? other$tagging != null : !((Object)this$tagging).equals(other$tagging)) {
            return false;
        }
        Optional<AccessControlPolicy> this$acl = this.getAcl();
        Optional<AccessControlPolicy> other$acl = other.getAcl();
        if (this$acl == null ? other$acl != null : !((Object)this$acl).equals(other$acl)) {
            return false;
        }
        Optional<String> this$policy = this.getPolicy();
        Optional<String> other$policy = other.getPolicy();
        if (this$policy == null ? other$policy != null : !((Object)this$policy).equals(other$policy)) {
            return false;
        }
        Optional<String> this$replication = this.getReplication();
        Optional<String> other$replication = other.getReplication();
        if (this$replication == null ? other$replication != null : !((Object)this$replication).equals(other$replication)) {
            return false;
        }
        Optional<String> this$encryption = this.getEncryption();
        Optional<String> other$encryption = other.getEncryption();
        return !(this$encryption == null ? other$encryption != null : !((Object)this$encryption).equals(other$encryption));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BucketMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $creationDate = this.getCreationDate();
        result = result * 59 + (int)($creationDate >>> 32 ^ $creationDate);
        Boolean $versioningEnabled = this.getVersioningEnabled();
        result = result * 59 + ($versioningEnabled == null ? 43 : ((Object)$versioningEnabled).hashCode());
        ConcurrentSkipListMap<String, ObjectMetadata> $objectMap = this.getObjectMap();
        result = result * 59 + ($objectMap == null ? 43 : ((Object)$objectMap).hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        NavigableMap<String, NavigableMap<String, UploadMetadata>> $uploads = this.getUploads();
        result = result * 59 + ($uploads == null ? 43 : $uploads.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        Optional<Collection<Map<String, String>>> $tagging = this.getTagging();
        result = result * 59 + ($tagging == null ? 43 : ((Object)$tagging).hashCode());
        Optional<AccessControlPolicy> $acl = this.getAcl();
        result = result * 59 + ($acl == null ? 43 : ((Object)$acl).hashCode());
        Optional<String> $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)$policy).hashCode());
        Optional<String> $replication = this.getReplication();
        result = result * 59 + ($replication == null ? 43 : ((Object)$replication).hashCode());
        Optional<String> $encryption = this.getEncryption();
        result = result * 59 + ($encryption == null ? 43 : ((Object)$encryption).hashCode());
        return result;
    }

    public String toString() {
        return "BucketMetadata(objectMap=" + this.getObjectMap() + ", creationDate=" + this.getCreationDate() + ", region=" + this.getRegion() + ", uploads=" + this.getUploads() + ", versioningEnabled=" + this.getVersioningEnabled() + ", bucketName=" + this.getBucketName() + ", tagging=" + this.getTagging() + ", acl=" + this.getAcl() + ", policy=" + this.getPolicy() + ", replication=" + this.getReplication() + ", encryption=" + this.getEncryption() + ")";
    }
}

