/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.model;

import com.robothy.s3.core.exception.LocalS3InvalidArgumentException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ContinuationParameters {
    private Character delimiter;
    private String encodingType;
    private boolean fetchOwner;
    private int maxKeys;
    private String prefix;
    private String startAfter;

    public String encode() {
        String joined = Stream.of(this.encodeDelimiter(), this.encodeEncodingType(), this.encodeFetchOwner(), this.encodeMaxKeys(), this.encodePrefix(), this.encodeStartAfter()).filter(StringUtils::isNotBlank).collect(Collectors.joining("/"));
        String hashAppended = joined + "/" + joined.hashCode();
        return Base64.getEncoder().encodeToString(hashAppended.getBytes(StandardCharsets.UTF_8));
    }

    private String encodeDelimiter() {
        return Objects.isNull(this.delimiter) ? "" : 1 + URLEncoder.encode(this.delimiter + "", StandardCharsets.UTF_8);
    }

    private String encodeEncodingType() {
        return Objects.isNull(this.encodingType) ? "" : 2 + URLEncoder.encode(this.encodingType, StandardCharsets.UTF_8);
    }

    private String encodeFetchOwner() {
        return this.fetchOwner ? "3" : "";
    }

    private String encodeMaxKeys() {
        return "4" + this.maxKeys;
    }

    private String encodePrefix() {
        return Objects.isNull(this.prefix) ? "" : 5 + URLEncoder.encode(this.prefix, StandardCharsets.UTF_8);
    }

    private String encodeStartAfter() {
        return Objects.isNull(this.startAfter) ? "" : 6 + URLEncoder.encode(this.startAfter, StandardCharsets.UTF_8);
    }

    public static ContinuationParameters decode(String continuationToken) {
        String hashAppended = ContinuationParameters.ensureContinuationTokenIsBase64Encoded(continuationToken);
        String joined = ContinuationParameters.verifyHash(hashAppended);
        return ContinuationParameters.decodeParameters(joined);
    }

    private static String ensureContinuationTokenIsBase64Encoded(String continuationToken) {
        try {
            return new String(Base64.getDecoder().decode(continuationToken), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            throw new LocalS3InvalidArgumentException("continuation-token", continuationToken, "The continuation token provided is incorrect.");
        }
    }

    private static String verifyHash(String hashAppended) {
        String joined;
        int lastSlash = hashAppended.lastIndexOf("/");
        if (-1 == lastSlash) {
            throw new LocalS3InvalidArgumentException("continuation-token", hashAppended, "The continuation token provided is incorrect.");
        }
        int hash = Integer.parseInt(hashAppended.substring(lastSlash + 1));
        if (hash != (joined = hashAppended.substring(0, lastSlash)).hashCode()) {
            throw new LocalS3InvalidArgumentException("continuation-token", hashAppended, "The continuation token provided is incorrect.");
        }
        return joined;
    }

    private static ContinuationParameters decodeParameters(String joined) {
        String[] parts = joined.split("/");
        if (parts.length == 0) {
            return ContinuationParameters.builder().build();
        }
        ContinuationParametersBuilder builder = ContinuationParameters.builder();
        Arrays.stream(parts).forEach(part -> {
            if (StringUtils.isBlank((CharSequence)part)) {
                return;
            }
            switch (part.charAt(0)) {
                case '1': {
                    builder.delimiter(Character.valueOf(URLDecoder.decode(part.substring(1), StandardCharsets.UTF_8).charAt(0)));
                    break;
                }
                case '2': {
                    builder.encodingType(URLDecoder.decode(part.substring(1), StandardCharsets.UTF_8));
                    break;
                }
                case '3': {
                    builder.fetchOwner(true);
                    break;
                }
                case '4': {
                    builder.maxKeys(Integer.parseInt(part.substring(1)));
                    break;
                }
                case '5': {
                    builder.prefix(URLDecoder.decode(part.substring(1), StandardCharsets.UTF_8));
                    break;
                }
                case '6': {
                    builder.startAfter(URLDecoder.decode(part.substring(1), StandardCharsets.UTF_8));
                    break;
                }
                default: {
                    throw new LocalS3InvalidArgumentException("continuation-token", joined, "The continuation token provided is incorrect.");
                }
            }
        });
        return builder.build();
    }

    ContinuationParameters(Character delimiter, String encodingType, boolean fetchOwner, int maxKeys, String prefix, String startAfter) {
        this.delimiter = delimiter;
        this.encodingType = encodingType;
        this.fetchOwner = fetchOwner;
        this.maxKeys = maxKeys;
        this.prefix = prefix;
        this.startAfter = startAfter;
    }

    public static ContinuationParametersBuilder builder() {
        return new ContinuationParametersBuilder();
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public boolean isFetchOwner() {
        return this.fetchOwner;
    }

    public int getMaxKeys() {
        return this.maxKeys;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getStartAfter() {
        return this.startAfter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContinuationParameters)) {
            return false;
        }
        ContinuationParameters other = (ContinuationParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFetchOwner() != other.isFetchOwner()) {
            return false;
        }
        if (this.getMaxKeys() != other.getMaxKeys()) {
            return false;
        }
        Character this$delimiter = this.getDelimiter();
        Character other$delimiter = other.getDelimiter();
        if (this$delimiter == null ? other$delimiter != null : !((Object)this$delimiter).equals(other$delimiter)) {
            return false;
        }
        String this$encodingType = this.getEncodingType();
        String other$encodingType = other.getEncodingType();
        if (this$encodingType == null ? other$encodingType != null : !this$encodingType.equals(other$encodingType)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$startAfter = this.getStartAfter();
        String other$startAfter = other.getStartAfter();
        return !(this$startAfter == null ? other$startAfter != null : !this$startAfter.equals(other$startAfter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContinuationParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFetchOwner() ? 79 : 97);
        result = result * 59 + this.getMaxKeys();
        Character $delimiter = this.getDelimiter();
        result = result * 59 + ($delimiter == null ? 43 : ((Object)$delimiter).hashCode());
        String $encodingType = this.getEncodingType();
        result = result * 59 + ($encodingType == null ? 43 : $encodingType.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $startAfter = this.getStartAfter();
        result = result * 59 + ($startAfter == null ? 43 : $startAfter.hashCode());
        return result;
    }

    public static class ContinuationParametersBuilder {
        private Character delimiter;
        private String encodingType;
        private boolean fetchOwner;
        private int maxKeys;
        private String prefix;
        private String startAfter;

        ContinuationParametersBuilder() {
        }

        public ContinuationParametersBuilder delimiter(Character delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public ContinuationParametersBuilder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        public ContinuationParametersBuilder fetchOwner(boolean fetchOwner) {
            this.fetchOwner = fetchOwner;
            return this;
        }

        public ContinuationParametersBuilder maxKeys(int maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public ContinuationParametersBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public ContinuationParametersBuilder startAfter(String startAfter) {
            this.startAfter = startAfter;
            return this;
        }

        public ContinuationParameters build() {
            return new ContinuationParameters(this.delimiter, this.encodingType, this.fetchOwner, this.maxKeys, this.prefix, this.startAfter);
        }

        public String toString() {
            return "ContinuationParameters.ContinuationParametersBuilder(delimiter=" + this.delimiter + ", encodingType=" + this.encodingType + ", fetchOwner=" + this.fetchOwner + ", maxKeys=" + this.maxKeys + ", prefix=" + this.prefix + ", startAfter=" + this.startAfter + ")";
        }
    }
}

