/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.model;

import com.robothy.s3.core.model.internal.BucketMetadata;
import java.util.Optional;

public class Bucket {
    private String name;
    private Boolean versioningEnabled;
    private String region;
    private long creationDate;

    public Optional<String> getRegion() {
        return Optional.ofNullable(this.region);
    }

    public static Bucket fromBucketMetadata(BucketMetadata bucketMetadata) {
        return Bucket.builder().name(bucketMetadata.getBucketName()).versioningEnabled(bucketMetadata.getVersioningEnabled()).region(bucketMetadata.getRegion()).creationDate(bucketMetadata.getCreationDate()).build();
    }

    public static BucketBuilder builder() {
        return new BucketBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Boolean getVersioningEnabled() {
        return this.versioningEnabled;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersioningEnabled(Boolean versioningEnabled) {
        this.versioningEnabled = versioningEnabled;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public String toString() {
        return "Bucket(name=" + this.getName() + ", versioningEnabled=" + this.getVersioningEnabled() + ", region=" + this.getRegion() + ", creationDate=" + this.getCreationDate() + ")";
    }

    public Bucket(String name, Boolean versioningEnabled, String region, long creationDate) {
        this.name = name;
        this.versioningEnabled = versioningEnabled;
        this.region = region;
        this.creationDate = creationDate;
    }

    public Bucket() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bucket)) {
            return false;
        }
        Bucket other = (Bucket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreationDate() != other.getCreationDate()) {
            return false;
        }
        Boolean this$versioningEnabled = this.getVersioningEnabled();
        Boolean other$versioningEnabled = other.getVersioningEnabled();
        if (this$versioningEnabled == null ? other$versioningEnabled != null : !((Object)this$versioningEnabled).equals(other$versioningEnabled)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<String> this$region = this.getRegion();
        Optional<String> other$region = other.getRegion();
        return !(this$region == null ? other$region != null : !((Object)this$region).equals(other$region));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Bucket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $creationDate = this.getCreationDate();
        result = result * 59 + (int)($creationDate >>> 32 ^ $creationDate);
        Boolean $versioningEnabled = this.getVersioningEnabled();
        result = result * 59 + ($versioningEnabled == null ? 43 : ((Object)$versioningEnabled).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<String> $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : ((Object)$region).hashCode());
        return result;
    }

    public static class BucketBuilder {
        private String name;
        private Boolean versioningEnabled;
        private String region;
        private long creationDate;

        BucketBuilder() {
        }

        public BucketBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BucketBuilder versioningEnabled(Boolean versioningEnabled) {
            this.versioningEnabled = versioningEnabled;
            return this;
        }

        public BucketBuilder region(String region) {
            this.region = region;
            return this;
        }

        public BucketBuilder creationDate(long creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public Bucket build() {
            return new Bucket(this.name, this.versioningEnabled, this.region, this.creationDate);
        }

        public String toString() {
            return "Bucket.BucketBuilder(name=" + this.name + ", versioningEnabled=" + this.versioningEnabled + ", region=" + this.region + ", creationDate=" + this.creationDate + ")";
        }
    }
}

