/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.exception;

public enum S3ErrorCode {
    AccessDenied("AccessDenied", 403, "Access Denied"),
    BucketAlreadyExists("BucketAlreadyExists", 409, "The requested bucket name is not available. The bucket namespace is shared by all users of the system. Please select a different name and try again."),
    BucketNotEmpty("BucketNotEmpty", 409, "The bucket you tried to delete is not empty."),
    EntityTooSmall("EntityTooSmall", 400, "Your proposed upload is smaller than the minimum allowed object size."),
    EntityTooLarge("EntityTooLarge", 400, "Your proposed upload exceeds the maximum allowed object size."),
    IllegalVersioningConfigurationException("IllegalVersioningConfigurationException", 400, "Indicates that the versioning configuration specified in the request is invalid."),
    InternalError("InternalError", 500, "We encountered an internal error. Please try again."),
    InvalidArgument("InvalidArgument", 400, "Invalid Argument"),
    InvalidBucketName("InvalidBucketName", 400, "The specified bucket is not valid."),
    InvalidPart("InvalidPart", 400, "One or more of the specified parts could not be found. The part might not have been uploaded, or the specified entity tag might not have matched the part's entity tag."),
    InvalidPartOrder("InvalidPartOrder", 400, "The list of parts was not in ascending order. Parts list must be specified in order by part number."),
    InvalidPolicyDocument("InvalidPolicyDocument", 400, "The content of the form does not meet the conditions specified in the policy document."),
    InvalidRange("InvalidRange", 416, "The requested range cannot be satisfied."),
    InvalidRequest("InvalidRequest", 400, ""),
    InvalidSecurity("InvalidSecurity", 403, "The provided security credentials are not valid."),
    InvalidStorageClass("InvalidStorageClass", 400, "The storage class you specified is not valid."),
    KeyTooLongError("KeyTooLongError", 400, "Your key is too long."),
    MaxMessageLengthExceeded("MaxMessageLengthExceeded", 400, "Your request was too big."),
    MaxPostPreDataLengthExceededError("MaxPostPreDataLengthExceededError", 400, "Your POST request fields preceding the upload file were too large."),
    MetadataTooLarge("MetadataTooLarge", 400, "Your metadata headers exceed the maximum allowed metadata size."),
    MethodNotAllowed("MethodNotAllowed", 405, "The specified method is not allowed against this resource."),
    MissingContentLength("MissingContentLength", 411, "You must provide the Content-Length HTTP header."),
    MissingRequestBodyError("MissingRequestBodyError", 400, "This happens when the user sends an empty XML document as a request. The error message is, \"Request body is empty.\""),
    NoLoggingStatusForKey("NoLoggingStatusForKey", 400, "There is no such thing as a logging status subresource for a key."),
    NoSuchBucket("NoSuchBucket", 404, "The specified bucket does not exist."),
    NoSuchBucketPolicy("NoSuchBucketPolicy", 404, "The specified bucket does not have a bucket policy."),
    NoSuchTagSet("NoSuchTagSet", 404, "The TagSet does not exist."),
    NoSuchKey("NoSuchKey", 404, "The specified key does not exist."),
    NoSuchLifecycleConfiguration("NoSuchLifecycleConfiguration", 404, "The lifecycle configuration does not exist."),
    NoSuchUpload("NoSuchUpload", 404, "The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed."),
    NoSuchVersion("NoSuchVersion", 404, "Indicates that the version ID specified in the request does not match an existing version."),
    NotImplemented("NotImplemented", 501, "A header you provided implies functionality that is not implemented."),
    OperationAborted("OperationAborted", 409, "A conflicting conditional action is currently in progress against this resource. Try again."),
    PreconditionFailed("PreconditionFailed", 412, "At least one of the preconditions you specified did not hold."),
    Redirect("Redirect", 307, "Temporary redirect."),
    RequestIsNotMultiPartContent("RequestIsNotMultiPartContent", 400, "Bucket POST must be of the enclosure-type multipart/form-data."),
    RequestTimeout("RequestTimeout", 400, "Your socket connection to the server was not read from or written to within the timeout period."),
    RequestTimeTooSkewed("RequestTimeTooSkewed", 403, "The difference between the request time and the server's time is too large."),
    RequestTorrentOfBucketError("RequestTorrentOfBucketError", 400, "Requesting the torrent file of a bucket is not permitted."),
    ReplicationConfigurationNotFoundError("ReplicationConfigurationNotFoundError", 404, "The replication configuration was not found"),
    ServerSideEncryptionConfigurationNotFoundError("ServerSideEncryptionConfigurationNotFoundError", 404, "The server side encryption configuration was not found"),
    ServiceUnavailable("ServiceUnavailable", 503, "Service is unable to handle request."),
    TooManyBuckets("TooManyBuckets", 400, "You have attempted to create more buckets than allowed."),
    UnexpectedContent("UnexpectedContent", 400, "This request does not support content."),
    UserKeyMustBeSpecified("UserKeyMustBeSpecified", 400, "The bucket POST must contain the specified field name. If it is specified, check the order of the fields.");

    private final int httpStatus;
    private final String code;
    private final String description;

    private S3ErrorCode(String code, int httpStatus, String description) {
        this.code = code;
        this.description = description;
        this.httpStatus = httpStatus;
    }

    public String code() {
        return this.code;
    }

    public int httpStatus() {
        return this.httpStatus;
    }

    public String description() {
        return this.description;
    }
}

