/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.asserionts;

import com.robothy.s3.core.exception.ObjectNotExistException;
import com.robothy.s3.core.exception.UploadNotExistException;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.model.internal.UploadMetadata;
import com.robothy.s3.core.model.internal.UploadPartMetadata;
import java.util.NavigableMap;

public class UploadAssertions {
    public static NavigableMap<String, UploadMetadata> assertKeyExists(BucketMetadata bucketMetadata, String key) {
        if (!bucketMetadata.getUploads().containsKey(key)) {
            throw new ObjectNotExistException(key);
        }
        return (NavigableMap)bucketMetadata.getUploads().get(key);
    }

    public static UploadMetadata assertUploadExists(BucketMetadata bucketMetadata, String key, String uploadId) {
        NavigableMap<String, UploadMetadata> uploadMetadataMap = UploadAssertions.assertKeyExists(bucketMetadata, key);
        if (!uploadMetadataMap.containsKey(uploadId)) {
            throw new UploadNotExistException(key, uploadId);
        }
        return (UploadMetadata)uploadMetadataMap.get(uploadId);
    }

    public static UploadPartMetadata assertPartNumberExists(UploadMetadata uploadMetadata, Integer partNumber) {
        if (!uploadMetadata.getParts().containsKey(partNumber)) {
            throw new IllegalArgumentException("Part number " + partNumber + " not exists.");
        }
        return (UploadPartMetadata)uploadMetadata.getParts().get(partNumber);
    }
}

