/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.s3.core.asserionts;

import com.robothy.s3.core.exception.BucketAlreadyExistsException;
import com.robothy.s3.core.exception.BucketNotEmptyException;
import com.robothy.s3.core.exception.BucketNotExistException;
import com.robothy.s3.core.exception.BucketPolicyNotExistException;
import com.robothy.s3.core.exception.BucketReplicationNotExistException;
import com.robothy.s3.core.exception.BucketTaggingNotExistException;
import com.robothy.s3.core.exception.InvalidBucketNameException;
import com.robothy.s3.core.exception.ServerSideEncryptionConfigurationNotFoundException;
import com.robothy.s3.core.model.internal.BucketMetadata;
import com.robothy.s3.core.model.internal.LocalS3Metadata;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BucketAssertions {
    public static String assertBucketNameIsValid(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new InvalidBucketNameException(bucketName);
        }
        return bucketName;
    }

    public static BucketMetadata assertBucketExists(LocalS3Metadata s3Metadata, String bucketName) {
        return s3Metadata.getBucketMetadata(bucketName).orElseThrow(() -> new BucketNotExistException(bucketName));
    }

    public static void assertBucketNotExists(LocalS3Metadata s3Metadata, String bucketName) {
        if (s3Metadata.getBucketMetadataMap().containsKey(bucketName)) {
            throw new BucketAlreadyExistsException(bucketName);
        }
    }

    public static void assertBucketIsEmpty(BucketMetadata bucketMetadata) {
        if (!bucketMetadata.getObjectMap().isEmpty()) {
            throw new BucketNotEmptyException(bucketMetadata.getBucketName());
        }
    }

    public static Collection<Map<String, String>> assertBucketTaggingExist(BucketMetadata bucketMetadata) {
        return bucketMetadata.getTagging().orElseThrow(() -> new BucketTaggingNotExistException(bucketMetadata.getBucketName()));
    }

    public static String assertBucketPolicyExist(LocalS3Metadata s3Metadata, String bucketName) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(s3Metadata, bucketName);
        return BucketAssertions.assertBucketPolicyExist(bucketMetadata);
    }

    public static String assertBucketPolicyExist(BucketMetadata bucketMetadata) {
        return bucketMetadata.getPolicy().orElseThrow(() -> new BucketPolicyNotExistException(bucketMetadata.getBucketName()));
    }

    public static String assertBucketReplicationExist(LocalS3Metadata s3Metadata, String bucketName) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(s3Metadata, bucketName);
        return bucketMetadata.getReplication().orElseThrow(BucketReplicationNotExistException::new);
    }

    public static String assertBucketEncryptionExist(LocalS3Metadata localS3Metadata, String bucketName) {
        BucketMetadata bucketMetadata = BucketAssertions.assertBucketExists(localS3Metadata, bucketName);
        return bucketMetadata.getEncryption().orElseThrow(() -> new ServerSideEncryptionConfigurationNotFoundException(bucketName));
    }
}

