/*
 * Decompiled with CFR 0.152.
 */
package feign.jaxb;

import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.jaxb.JAXBContextFactory;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JAXBDecoder
implements Decoder {
    private final JAXBContextFactory jaxbContextFactory;
    private final boolean namespaceAware;

    public JAXBDecoder(JAXBContextFactory jaxbContextFactory) {
        this.jaxbContextFactory = jaxbContextFactory;
        this.namespaceAware = true;
    }

    private JAXBDecoder(Builder builder) {
        this.jaxbContextFactory = builder.jaxbContextFactory;
        this.namespaceAware = builder.namespaceAware;
    }

    public Object decode(Response response, Type type) throws IOException {
        if (response.status() == 204) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        while (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            type = ptype.getRawType();
        }
        if (!(type instanceof Class)) {
            throw new UnsupportedOperationException("JAXB only supports decoding raw types. Found " + type);
        }
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
            saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            saxParserFactory.setNamespaceAware(this.namespaceAware);
            Object object = this.jaxbContextFactory.createUnmarshaller((Class)type).unmarshal((Source)new SAXSource(saxParserFactory.newSAXParser().getXMLReader(), new InputSource(response.body().asInputStream())));
            return object;
        }
        catch (JAXBException | ParserConfigurationException | SAXException e) {
            throw new DecodeException(response.status(), e.toString(), response.request(), e);
        }
        finally {
            if (response.body() != null) {
                response.body().close();
            }
        }
    }

    public static class Builder {
        private boolean namespaceAware = true;
        private JAXBContextFactory jaxbContextFactory;

        public Builder withNamespaceAware(boolean namespaceAware) {
            this.namespaceAware = namespaceAware;
            return this;
        }

        public Builder withJAXBContextFactory(JAXBContextFactory jaxbContextFactory) {
            this.jaxbContextFactory = jaxbContextFactory;
            return this;
        }

        public JAXBDecoder build() {
            if (this.jaxbContextFactory == null) {
                throw new IllegalStateException("JAXBContextFactory must be non-null");
            }
            return new JAXBDecoder(this);
        }
    }
}

