/*
 * Decompiled with CFR 0.152.
 */
package marquez.client.models;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import marquez.client.Utils;

public class SourceMeta {
    private final String type;
    private final URI connectionUrl;
    @Nullable
    private final String description;

    public SourceMeta(@NonNull String type, @NonNull URI connectionUrl, @Nullable String description) {
        Objects.requireNonNull(type, "type is marked non-null but is null");
        Objects.requireNonNull(connectionUrl, "connectionUrl is marked non-null but is null");
        this.type = type;
        this.connectionUrl = connectionUrl;
        this.description = description;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public String toJson() {
        return Utils.toJson(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceMeta)) {
            return false;
        }
        SourceMeta other = (SourceMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        URI this$connectionUrl = this.getConnectionUrl();
        URI other$connectionUrl = other.getConnectionUrl();
        if (this$connectionUrl == null ? other$connectionUrl != null : !((Object)this$connectionUrl).equals(other$connectionUrl)) {
            return false;
        }
        Optional<String> this$description = this.getDescription();
        Optional<String> other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !((Object)this$description).equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SourceMeta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        URI $connectionUrl = this.getConnectionUrl();
        result = result * 59 + ($connectionUrl == null ? 43 : ((Object)$connectionUrl).hashCode());
        Optional<String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SourceMeta(type=" + this.getType() + ", connectionUrl=" + this.getConnectionUrl() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public URI getConnectionUrl() {
        return this.connectionUrl;
    }

    public static class Builder {
        private String type;
        private URI connectionUrl;
        @Nullable
        private String description;

        public Builder type(@NonNull String type) {
            Objects.requireNonNull(type, "type is marked non-null but is null");
            this.type = type;
            return this;
        }

        public Builder connectionUrl(@NonNull String connectionUrlAsString) {
            Objects.requireNonNull(connectionUrlAsString, "connectionUrlAsString is marked non-null but is null");
            return this.connectionUrl(URI.create(connectionUrlAsString));
        }

        public Builder connectionUrl(@NonNull URI connectionUrl) {
            Objects.requireNonNull(connectionUrl, "connectionUrl is marked non-null but is null");
            this.connectionUrl = connectionUrl;
            return this;
        }

        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public SourceMeta build() {
            return new SourceMeta(this.type, this.connectionUrl, this.description);
        }
    }
}

