/*
 * Decompiled with CFR 0.152.
 */
package marquez.client.models;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import marquez.client.Utils;
import marquez.client.models.InputDatasetVersion;
import marquez.client.models.OutputDatasetVersion;
import marquez.client.models.RunMeta;
import marquez.client.models.RunState;

public final class Run
extends RunMeta {
    private final Instant createdAt;
    private final Instant updatedAt;
    private final RunState state;
    @Nullable
    private final Instant startedAt;
    @Nullable
    private final Long durationMs;
    @Nullable
    private final Instant endedAt;
    private final Map<String, Object> facets;
    private final List<InputDatasetVersion> inputDatasetVersions;
    private final List<OutputDatasetVersion> outputDatasetVersions;

    public Run(@NonNull String id, @NonNull Instant createdAt, @NonNull Instant updatedAt, @Nullable Instant nominalStartTime, @Nullable Instant nominalEndTime, @NonNull RunState state, @Nullable Instant startedAt, @Nullable Instant endedAt, @Nullable Long durationMs, @Nullable Map<String, String> args, @Nullable Map<String, Object> facets, @Nullable List<InputDatasetVersion> inputDatasetVersions, @Nullable List<OutputDatasetVersion> outputDatasetVersions) {
        super(id, nominalStartTime, nominalEndTime, args);
        Objects.requireNonNull(id, "id is marked non-null but is null");
        Objects.requireNonNull(createdAt, "createdAt is marked non-null but is null");
        Objects.requireNonNull(updatedAt, "updatedAt is marked non-null but is null");
        Objects.requireNonNull(state, "state is marked non-null but is null");
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.state = state;
        this.startedAt = startedAt;
        this.durationMs = durationMs;
        this.endedAt = endedAt;
        this.facets = facets == null ? ImmutableMap.of() : ImmutableMap.copyOf(facets);
        this.inputDatasetVersions = inputDatasetVersions == null ? Collections.emptyList() : inputDatasetVersions;
        this.outputDatasetVersions = outputDatasetVersions == null ? Collections.emptyList() : outputDatasetVersions;
    }

    public Optional<Instant> getStartedAt() {
        return Optional.ofNullable(this.startedAt);
    }

    public Optional<Instant> getEndedAt() {
        return Optional.ofNullable(this.endedAt);
    }

    public Optional<Long> getDurationMs() {
        return Optional.ofNullable(this.durationMs);
    }

    public boolean hasFacets() {
        return !this.facets.isEmpty();
    }

    public static Run fromJson(@NonNull String json) {
        Objects.requireNonNull(json, "json is marked non-null but is null");
        return Utils.fromJson(json, new TypeReference<Run>(){});
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Run)) {
            return false;
        }
        Run other = (Run)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Optional<Long> this$durationMs = this.getDurationMs();
        Optional<Long> other$durationMs = other.getDurationMs();
        if (this$durationMs == null ? other$durationMs != null : !((Object)this$durationMs).equals(other$durationMs)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        RunState this$state = this.getState();
        RunState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        Optional<Instant> this$startedAt = this.getStartedAt();
        Optional<Instant> other$startedAt = other.getStartedAt();
        if (this$startedAt == null ? other$startedAt != null : !((Object)this$startedAt).equals(other$startedAt)) {
            return false;
        }
        Optional<Instant> this$endedAt = this.getEndedAt();
        Optional<Instant> other$endedAt = other.getEndedAt();
        if (this$endedAt == null ? other$endedAt != null : !((Object)this$endedAt).equals(other$endedAt)) {
            return false;
        }
        Map<String, Object> this$facets = this.getFacets();
        Map<String, Object> other$facets = other.getFacets();
        if (this$facets == null ? other$facets != null : !((Object)this$facets).equals(other$facets)) {
            return false;
        }
        List<InputDatasetVersion> this$inputDatasetVersions = this.getInputDatasetVersions();
        List<InputDatasetVersion> other$inputDatasetVersions = other.getInputDatasetVersions();
        if (this$inputDatasetVersions == null ? other$inputDatasetVersions != null : !((Object)this$inputDatasetVersions).equals(other$inputDatasetVersions)) {
            return false;
        }
        List<OutputDatasetVersion> this$outputDatasetVersions = this.getOutputDatasetVersions();
        List<OutputDatasetVersion> other$outputDatasetVersions = other.getOutputDatasetVersions();
        return !(this$outputDatasetVersions == null ? other$outputDatasetVersions != null : !((Object)this$outputDatasetVersions).equals(other$outputDatasetVersions));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Run;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Optional<Long> $durationMs = this.getDurationMs();
        result = result * 59 + ($durationMs == null ? 43 : ((Object)$durationMs).hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        RunState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        Optional<Instant> $startedAt = this.getStartedAt();
        result = result * 59 + ($startedAt == null ? 43 : ((Object)$startedAt).hashCode());
        Optional<Instant> $endedAt = this.getEndedAt();
        result = result * 59 + ($endedAt == null ? 43 : ((Object)$endedAt).hashCode());
        Map<String, Object> $facets = this.getFacets();
        result = result * 59 + ($facets == null ? 43 : ((Object)$facets).hashCode());
        List<InputDatasetVersion> $inputDatasetVersions = this.getInputDatasetVersions();
        result = result * 59 + ($inputDatasetVersions == null ? 43 : ((Object)$inputDatasetVersions).hashCode());
        List<OutputDatasetVersion> $outputDatasetVersions = this.getOutputDatasetVersions();
        result = result * 59 + ($outputDatasetVersions == null ? 43 : ((Object)$outputDatasetVersions).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Run(super=" + super.toString() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", state=" + this.getState() + ", startedAt=" + this.getStartedAt() + ", durationMs=" + this.getDurationMs() + ", endedAt=" + this.getEndedAt() + ", facets=" + this.getFacets() + ", inputDatasetVersions=" + this.getInputDatasetVersions() + ", outputDatasetVersions=" + this.getOutputDatasetVersions() + ")";
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public RunState getState() {
        return this.state;
    }

    @Generated
    public Map<String, Object> getFacets() {
        return this.facets;
    }

    @Generated
    public List<InputDatasetVersion> getInputDatasetVersions() {
        return this.inputDatasetVersions;
    }

    @Generated
    public List<OutputDatasetVersion> getOutputDatasetVersions() {
        return this.outputDatasetVersions;
    }
}

