/*
 * Decompiled with CFR 0.152.
 */
package marquez.client.models;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import marquez.client.models.Edge;
import marquez.client.models.NodeData;
import marquez.client.models.NodeId;
import marquez.client.models.NodeType;

@JsonPropertyOrder(value={"id", "type", "data", "inEdges", "outEdges"})
public final class Node {
    private final NodeId id;
    private final NodeType type;
    @Nullable
    private NodeData data;
    private final Set<Edge> inEdges;
    private final Set<Edge> outEdges;

    public Node(@NonNull NodeId id, @NonNull NodeType type, @Nullable NodeData data, @Nullable Set<Edge> inEdges, @Nullable Set<Edge> outEdges) {
        Objects.requireNonNull(id, "id is marked non-null but is null");
        Objects.requireNonNull(type, "type is marked non-null but is null");
        this.id = id;
        this.type = type;
        this.data = data;
        this.inEdges = inEdges == null ? ImmutableSet.of() : ImmutableSortedSet.copyOf(inEdges);
        this.outEdges = outEdges == null ? ImmutableSet.of() : ImmutableSortedSet.copyOf(outEdges);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node other = (Node)o;
        NodeId this$id = this.getId();
        NodeId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        NodeType this$type = this.getType();
        NodeType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        NodeData this$data = this.getData();
        NodeData other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Set<Edge> this$inEdges = this.getInEdges();
        Set<Edge> other$inEdges = other.getInEdges();
        if (this$inEdges == null ? other$inEdges != null : !((Object)this$inEdges).equals(other$inEdges)) {
            return false;
        }
        Set<Edge> this$outEdges = this.getOutEdges();
        Set<Edge> other$outEdges = other.getOutEdges();
        return !(this$outEdges == null ? other$outEdges != null : !((Object)this$outEdges).equals(other$outEdges));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        NodeType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        NodeData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Set<Edge> $inEdges = this.getInEdges();
        result = result * 59 + ($inEdges == null ? 43 : ((Object)$inEdges).hashCode());
        Set<Edge> $outEdges = this.getOutEdges();
        result = result * 59 + ($outEdges == null ? 43 : ((Object)$outEdges).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Node(id=" + this.getId() + ", type=" + this.getType() + ", data=" + this.getData() + ", inEdges=" + this.getInEdges() + ", outEdges=" + this.getOutEdges() + ")";
    }

    @Generated
    public NodeId getId() {
        return this.id;
    }

    @Generated
    public NodeType getType() {
        return this.type;
    }

    @Nullable
    @Generated
    public NodeData getData() {
        return this.data;
    }

    @Generated
    public void setData(@Nullable NodeData data) {
        this.data = data;
    }

    @Generated
    public Set<Edge> getInEdges() {
        return this.inEdges;
    }

    @Generated
    public Set<Edge> getOutEdges() {
        return this.outEdges;
    }
}

