/*
 * Decompiled with CFR 0.152.
 */
package marquez.client.models;

import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URL;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import marquez.client.Utils;
import marquez.client.models.DatasetId;
import marquez.client.models.JobVersionId;
import marquez.client.models.Run;

public final class JobVersion {
    private final JobVersionId id;
    private final String name;
    private final Instant createdAt;
    private final UUID version;
    private final String namespace;
    @Nullable
    private final URL location;
    private final List<DatasetId> inputs;
    private final List<DatasetId> outputs;
    @Nullable
    private final Run latestRun;

    public JobVersion(@NonNull JobVersionId id, @NonNull String name, @NonNull Instant createdAt, @NonNull UUID version, @Nullable URL location, List<DatasetId> inputs, List<DatasetId> outputs, @Nullable Run latestRun) {
        Objects.requireNonNull(id, "id is marked non-null but is null");
        Objects.requireNonNull(name, "name is marked non-null but is null");
        Objects.requireNonNull(createdAt, "createdAt is marked non-null but is null");
        Objects.requireNonNull(version, "version is marked non-null but is null");
        this.id = id;
        this.name = name;
        this.createdAt = createdAt;
        this.version = version;
        this.namespace = id.getNamespace();
        this.location = location;
        this.inputs = inputs;
        this.outputs = outputs;
        this.latestRun = latestRun;
    }

    public Optional<URL> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public static JobVersion fromJson(@NonNull String json) {
        Objects.requireNonNull(json, "json is marked non-null but is null");
        return Utils.fromJson(json, new TypeReference<JobVersion>(){});
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobVersion)) {
            return false;
        }
        JobVersion other = (JobVersion)o;
        JobVersionId this$id = this.getId();
        JobVersionId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        UUID this$version = this.getVersion();
        UUID other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        Optional<URL> this$location = this.getLocation();
        Optional<URL> other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        List<DatasetId> this$inputs = this.getInputs();
        List<DatasetId> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<DatasetId> this$outputs = this.getOutputs();
        List<DatasetId> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        Run this$latestRun = this.getLatestRun();
        Run other$latestRun = other.getLatestRun();
        return !(this$latestRun == null ? other$latestRun != null : !((Object)this$latestRun).equals(other$latestRun));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JobVersionId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        UUID $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        Optional<URL> $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        List<DatasetId> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<DatasetId> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        Run $latestRun = this.getLatestRun();
        result = result * 59 + ($latestRun == null ? 43 : ((Object)$latestRun).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JobVersion(id=" + this.getId() + ", name=" + this.getName() + ", createdAt=" + this.getCreatedAt() + ", version=" + this.getVersion() + ", namespace=" + this.getNamespace() + ", location=" + this.getLocation() + ", inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ", latestRun=" + this.getLatestRun() + ")";
    }

    @Generated
    public JobVersionId getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public UUID getVersion() {
        return this.version;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public List<DatasetId> getInputs() {
        return this.inputs;
    }

    @Generated
    public List<DatasetId> getOutputs() {
        return this.outputs;
    }

    @Nullable
    @Generated
    public Run getLatestRun() {
        return this.latestRun;
    }
}

