/*
 * Decompiled with CFR 0.152.
 */
package marquez.client.models;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public class Field {
    private final String name;
    @Nullable
    private final String type;
    private final Set<String> tags;
    @Nullable
    String description;

    public Field(@NonNull String name, @Nullable String type, @Nullable Set<String> tags, @Nullable String description) {
        Objects.requireNonNull(name, "name is marked non-null but is null");
        this.name = name;
        this.type = type;
        this.tags = tags == null ? ImmutableSet.of() : ImmutableSet.copyOf(tags);
        this.description = description;
    }

    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field other = (Field)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<String> this$type = this.getType();
        Optional<String> other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Optional<String> this$description = this.getDescription();
        Optional<String> other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !((Object)this$description).equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Field;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<String> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Optional<String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Field(name=" + this.getName() + ", type=" + this.getType() + ", tags=" + this.getTags() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    public static final class Builder {
        private String name;
        @Nullable
        private String type;
        private Set<String> tags = Sets.newHashSet();
        @Nullable
        private String description;

        private Builder() {
        }

        public Builder name(@NonNull String name) {
            Objects.requireNonNull(name, "name is marked non-null but is null");
            this.name = name;
            return this;
        }

        public Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public Builder tags(@NonNull Set<String> tags) {
            Objects.requireNonNull(tags, "tags is marked non-null but is null");
            this.tags = tags;
            return this;
        }

        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Field build() {
            return new Field(this.name, this.type, this.tags, this.description);
        }
    }
}

