/*
 * Decompiled with CFR 0.152.
 */
package marquez.client.models;

import java.util.Comparator;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import marquez.client.models.NodeId;

public final class Edge
implements Comparable<Edge> {
    @NonNull
    private final NodeId origin;
    @NonNull
    private final NodeId destination;

    public static Edge of(@NonNull NodeId origin, @NonNull NodeId destination) {
        Objects.requireNonNull(origin, "origin is marked non-null but is null");
        Objects.requireNonNull(destination, "destination is marked non-null but is null");
        return new Edge(origin, destination);
    }

    @Override
    public int compareTo(Edge o) {
        return Comparator.comparing(Edge::getOrigin).thenComparing(Edge::getDestination).compare(this, o);
    }

    @Generated
    public Edge(@NonNull NodeId origin, @NonNull NodeId destination) {
        Objects.requireNonNull(origin, "origin is marked non-null but is null");
        Objects.requireNonNull(destination, "destination is marked non-null but is null");
        this.origin = origin;
        this.destination = destination;
    }

    @NonNull
    @Generated
    public NodeId getOrigin() {
        return this.origin;
    }

    @NonNull
    @Generated
    public NodeId getDestination() {
        return this.destination;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)o;
        NodeId this$origin = this.getOrigin();
        NodeId other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !((Object)this$origin).equals(other$origin)) {
            return false;
        }
        NodeId this$destination = this.getDestination();
        NodeId other$destination = other.getDestination();
        return !(this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : ((Object)$origin).hashCode());
        NodeId $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Edge(origin=" + this.getOrigin() + ", destination=" + this.getDestination() + ")";
    }
}

