/*
 * Decompiled with CFR 0.152.
 */
package marquez.client.models;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import marquez.client.models.DatasetType;
import marquez.client.models.DbTableMeta;
import marquez.client.models.Field;
import marquez.client.models.StreamMeta;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DbTableMeta.class, name="DB_TABLE"), @JsonSubTypes.Type(value=StreamMeta.class, name="STREAM")})
public abstract class DatasetMeta {
    @NonNull
    private final DatasetType type;
    @NonNull
    private final String physicalName;
    @NonNull
    private final String sourceName;
    @NonNull
    private final List<Field> fields;
    @NonNull
    private final Set<String> tags;
    @Nullable
    private final String description;
    @Nullable
    private final String runId;

    public DatasetMeta(@NonNull DatasetType type, @NonNull String physicalName, @NonNull String sourceName, @Nullable List<Field> fields, @Nullable Set<String> tags, @Nullable String description, @Nullable String runId) {
        Objects.requireNonNull(type, "type is marked non-null but is null");
        Objects.requireNonNull(physicalName, "physicalName is marked non-null but is null");
        Objects.requireNonNull(sourceName, "sourceName is marked non-null but is null");
        this.type = type;
        this.physicalName = physicalName;
        this.sourceName = sourceName;
        this.fields = fields == null ? ImmutableList.of() : ImmutableList.copyOf(fields);
        this.tags = tags == null ? ImmutableSet.of() : ImmutableSet.copyOf(tags);
        this.description = description;
        this.runId = runId;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getRunId() {
        return Optional.ofNullable(this.runId);
    }

    public abstract String toJson();

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatasetMeta)) {
            return false;
        }
        DatasetMeta other = (DatasetMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DatasetType this$type = this.getType();
        DatasetType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$physicalName = this.getPhysicalName();
        String other$physicalName = other.getPhysicalName();
        if (this$physicalName == null ? other$physicalName != null : !this$physicalName.equals(other$physicalName)) {
            return false;
        }
        String this$sourceName = this.getSourceName();
        String other$sourceName = other.getSourceName();
        if (this$sourceName == null ? other$sourceName != null : !this$sourceName.equals(other$sourceName)) {
            return false;
        }
        List<Field> this$fields = this.getFields();
        List<Field> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Optional<String> this$description = this.getDescription();
        Optional<String> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        Optional<String> this$runId = this.getRunId();
        Optional<String> other$runId = other.getRunId();
        return !(this$runId == null ? other$runId != null : !((Object)this$runId).equals(other$runId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DatasetMeta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DatasetType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $physicalName = this.getPhysicalName();
        result = result * 59 + ($physicalName == null ? 43 : $physicalName.hashCode());
        String $sourceName = this.getSourceName();
        result = result * 59 + ($sourceName == null ? 43 : $sourceName.hashCode());
        List<Field> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Optional<String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        Optional<String> $runId = this.getRunId();
        result = result * 59 + ($runId == null ? 43 : ((Object)$runId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DatasetMeta(type=" + this.getType() + ", physicalName=" + this.getPhysicalName() + ", sourceName=" + this.getSourceName() + ", fields=" + this.getFields() + ", tags=" + this.getTags() + ", description=" + this.getDescription() + ", runId=" + this.getRunId() + ")";
    }

    @NonNull
    @Generated
    public DatasetType getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getPhysicalName() {
        return this.physicalName;
    }

    @NonNull
    @Generated
    public String getSourceName() {
        return this.sourceName;
    }

    @NonNull
    @Generated
    public List<Field> getFields() {
        return this.fields;
    }

    @NonNull
    @Generated
    public Set<String> getTags() {
        return this.tags;
    }
}

