/*
 * Decompiled with CFR 0.152.
 */
package marquez.client.models;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import marquez.client.Utils;
import marquez.client.models.ColumnLineage;
import marquez.client.models.DatasetId;
import marquez.client.models.DatasetType;
import marquez.client.models.DbTable;
import marquez.client.models.Field;
import marquez.client.models.Stream;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DbTable.class, name="DB_TABLE"), @JsonSubTypes.Type(value=Stream.class, name="STREAM")})
public abstract class Dataset {
    @NonNull
    private final DatasetId id;
    @NonNull
    private final DatasetType type;
    @NonNull
    private final String name;
    @NonNull
    private final String physicalName;
    @NonNull
    private final Instant createdAt;
    @NonNull
    private final Instant updatedAt;
    @NonNull
    private final String namespace;
    @NonNull
    private final String sourceName;
    @NonNull
    private final List<Field> fields;
    @NonNull
    private final Set<String> tags;
    @Nullable
    private final Instant lastModifiedAt;
    @Nullable
    private final String description;
    @Nullable
    private List<ColumnLineage> columnLineage;
    private final Map<String, Object> facets;
    @Nullable
    private final UUID currentVersion;

    public Dataset(@NonNull DatasetId id, @NonNull DatasetType type, @NonNull String name, @NonNull String physicalName, @NonNull Instant createdAt, @NonNull Instant updatedAt, @NonNull String namespace, @NonNull String sourceName, @Nullable List<Field> fields, @Nullable Set<String> tags, @Nullable Instant lastModifiedAt, @Nullable String description, @Nullable List<ColumnLineage> columnLineage, @Nullable Map<String, Object> facets, @Nullable UUID currentVersion) {
        Objects.requireNonNull(id, "id is marked non-null but is null");
        Objects.requireNonNull(type, "type is marked non-null but is null");
        Objects.requireNonNull(name, "name is marked non-null but is null");
        Objects.requireNonNull(physicalName, "physicalName is marked non-null but is null");
        Objects.requireNonNull(createdAt, "createdAt is marked non-null but is null");
        Objects.requireNonNull(updatedAt, "updatedAt is marked non-null but is null");
        Objects.requireNonNull(namespace, "namespace is marked non-null but is null");
        Objects.requireNonNull(sourceName, "sourceName is marked non-null but is null");
        this.id = id;
        this.type = type;
        this.name = name;
        this.physicalName = physicalName;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.namespace = namespace;
        this.sourceName = sourceName;
        this.fields = fields == null ? ImmutableList.of() : ImmutableList.copyOf(fields);
        this.tags = tags == null ? ImmutableSet.of() : ImmutableSet.copyOf(tags);
        this.lastModifiedAt = lastModifiedAt;
        this.description = description;
        this.columnLineage = columnLineage;
        this.facets = facets == null ? ImmutableMap.of() : ImmutableMap.copyOf(facets);
        this.currentVersion = currentVersion;
    }

    public Optional<Instant> getLastModifiedAt() {
        return Optional.ofNullable(this.lastModifiedAt);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public boolean hasFacets() {
        return !this.facets.isEmpty();
    }

    public static Dataset fromJson(@NonNull String json) {
        Objects.requireNonNull(json, "json is marked non-null but is null");
        return Utils.fromJson(json, new TypeReference<Dataset>(){});
    }

    public Optional<UUID> getCurrentVersion() {
        return Optional.ofNullable(this.currentVersion);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DatasetId this$id = this.getId();
        DatasetId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        DatasetType this$type = this.getType();
        DatasetType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$physicalName = this.getPhysicalName();
        String other$physicalName = other.getPhysicalName();
        if (this$physicalName == null ? other$physicalName != null : !this$physicalName.equals(other$physicalName)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$sourceName = this.getSourceName();
        String other$sourceName = other.getSourceName();
        if (this$sourceName == null ? other$sourceName != null : !this$sourceName.equals(other$sourceName)) {
            return false;
        }
        List<Field> this$fields = this.getFields();
        List<Field> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Optional<Instant> this$lastModifiedAt = this.getLastModifiedAt();
        Optional<Instant> other$lastModifiedAt = other.getLastModifiedAt();
        if (this$lastModifiedAt == null ? other$lastModifiedAt != null : !((Object)this$lastModifiedAt).equals(other$lastModifiedAt)) {
            return false;
        }
        Optional<String> this$description = this.getDescription();
        Optional<String> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        List<ColumnLineage> this$columnLineage = this.getColumnLineage();
        List<ColumnLineage> other$columnLineage = other.getColumnLineage();
        if (this$columnLineage == null ? other$columnLineage != null : !((Object)this$columnLineage).equals(other$columnLineage)) {
            return false;
        }
        Map<String, Object> this$facets = this.getFacets();
        Map<String, Object> other$facets = other.getFacets();
        if (this$facets == null ? other$facets != null : !((Object)this$facets).equals(other$facets)) {
            return false;
        }
        Optional<UUID> this$currentVersion = this.getCurrentVersion();
        Optional<UUID> other$currentVersion = other.getCurrentVersion();
        return !(this$currentVersion == null ? other$currentVersion != null : !((Object)this$currentVersion).equals(other$currentVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dataset;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DatasetId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        DatasetType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $physicalName = this.getPhysicalName();
        result = result * 59 + ($physicalName == null ? 43 : $physicalName.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $sourceName = this.getSourceName();
        result = result * 59 + ($sourceName == null ? 43 : $sourceName.hashCode());
        List<Field> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Optional<Instant> $lastModifiedAt = this.getLastModifiedAt();
        result = result * 59 + ($lastModifiedAt == null ? 43 : ((Object)$lastModifiedAt).hashCode());
        Optional<String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        List<ColumnLineage> $columnLineage = this.getColumnLineage();
        result = result * 59 + ($columnLineage == null ? 43 : ((Object)$columnLineage).hashCode());
        Map<String, Object> $facets = this.getFacets();
        result = result * 59 + ($facets == null ? 43 : ((Object)$facets).hashCode());
        Optional<UUID> $currentVersion = this.getCurrentVersion();
        result = result * 59 + ($currentVersion == null ? 43 : ((Object)$currentVersion).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Dataset(id=" + this.getId() + ", type=" + this.getType() + ", name=" + this.getName() + ", physicalName=" + this.getPhysicalName() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", namespace=" + this.getNamespace() + ", sourceName=" + this.getSourceName() + ", fields=" + this.getFields() + ", tags=" + this.getTags() + ", lastModifiedAt=" + this.getLastModifiedAt() + ", description=" + this.getDescription() + ", columnLineage=" + this.getColumnLineage() + ", facets=" + this.getFacets() + ", currentVersion=" + this.getCurrentVersion() + ")";
    }

    @NonNull
    @Generated
    public DatasetId getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public DatasetType getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public String getPhysicalName() {
        return this.physicalName;
    }

    @NonNull
    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @NonNull
    @Generated
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @NonNull
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @NonNull
    @Generated
    public String getSourceName() {
        return this.sourceName;
    }

    @NonNull
    @Generated
    public List<Field> getFields() {
        return this.fields;
    }

    @NonNull
    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Nullable
    @Generated
    public List<ColumnLineage> getColumnLineage() {
        return this.columnLineage;
    }

    @Generated
    public Map<String, Object> getFacets() {
        return this.facets;
    }
}

