/*
 * Decompiled with CFR 0.152.
 */
package marquez.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import lombok.NonNull;
import marquez.client.MarquezClient;
import marquez.client.MarquezHttpException;
import marquez.client.Utils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MarquezHttp
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MarquezHttp.class);
    private final HttpClient http;
    @Nullable
    @VisibleForTesting
    final String apiKey;

    MarquezHttp(@NonNull HttpClient http, @Nullable String apiKey) {
        Objects.requireNonNull(http, "http is marked non-null but is null");
        this.http = http;
        this.apiKey = apiKey;
    }

    static MarquezHttp create(MarquezClient.Version version) {
        return MarquezHttp.create(version, null);
    }

    static MarquezHttp create(@NonNull MarquezClient.Version version, @Nullable String apiKey) {
        Objects.requireNonNull(version, "version is marked non-null but is null");
        UserAgent userAgent = UserAgent.of(version);
        CloseableHttpClient http = HttpClientBuilder.create().setUserAgent(userAgent.getValue()).build();
        return new MarquezHttp((HttpClient)http, apiKey);
    }

    static MarquezHttp create(@Nullable SSLContext sslContext, @NonNull MarquezClient.Version version, @Nullable String apiKey) {
        Objects.requireNonNull(version, "version is marked non-null but is null");
        UserAgent userAgent = UserAgent.of(version);
        CloseableHttpClient http = HttpClientBuilder.create().setUserAgent(userAgent.getValue()).setSSLContext(sslContext).build();
        return new MarquezHttp((HttpClient)http, apiKey);
    }

    String post(URL url) {
        return this.post(url, null);
    }

    String post(URL url, @Nullable String json) {
        log.debug("POST {}: {}", (Object)url, (Object)json);
        try {
            HttpPost request = new HttpPost();
            request.setURI(url.toURI());
            request.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
            if (json != null) {
                request.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
                request.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            }
            this.addAuthToReqIfKeyPresent((HttpRequestBase)request);
            HttpResponse response = this.http.execute((HttpUriRequest)request);
            this.throwOnHttpError(response);
            String bodyAsJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            log.debug("Response: {}", (Object)bodyAsJson);
            return bodyAsJson;
        }
        catch (IOException | URISyntaxException e) {
            throw new MarquezHttpException();
        }
    }

    String put(URL url, String json) {
        log.debug("PUT {}: {}", (Object)url, (Object)json);
        try {
            HttpPut request = new HttpPut();
            request.setURI(url.toURI());
            request.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
            request.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            request.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            this.addAuthToReqIfKeyPresent((HttpRequestBase)request);
            HttpResponse response = this.http.execute((HttpUriRequest)request);
            this.throwOnHttpError(response);
            String bodyAsJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            log.debug("Response: {}", (Object)bodyAsJson);
            return bodyAsJson;
        }
        catch (IOException | URISyntaxException e) {
            throw new MarquezHttpException();
        }
    }

    String get(URL url) {
        log.debug("GET {}", (Object)url);
        try {
            HttpGet request = new HttpGet();
            request.setURI(url.toURI());
            request.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
            this.addAuthToReqIfKeyPresent((HttpRequestBase)request);
            HttpResponse response = this.http.execute((HttpUriRequest)request);
            this.throwOnHttpError(response);
            String bodyAsJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            log.debug("Response: {}", (Object)bodyAsJson);
            return bodyAsJson;
        }
        catch (IOException | URISyntaxException e) {
            throw new MarquezHttpException();
        }
    }

    String delete(URL url) {
        log.debug("DELETE {}", (Object)url);
        try {
            HttpDelete request = new HttpDelete();
            request.setURI(url.toURI());
            request.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
            this.addAuthToReqIfKeyPresent((HttpRequestBase)request);
            HttpResponse response = this.http.execute((HttpUriRequest)request);
            this.throwOnHttpError(response);
            String bodyAsJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            log.debug("Response: {}", (Object)bodyAsJson);
            return bodyAsJson;
        }
        catch (IOException | URISyntaxException e) {
            throw new MarquezHttpException();
        }
    }

    private void throwOnHttpError(HttpResponse response) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        if (code >= 400 && code < 600) {
            throw new MarquezHttpException(HttpError.of(response));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.http instanceof Closeable) {
            ((Closeable)this.http).close();
        }
    }

    private void addAuthToReqIfKeyPresent(HttpRequestBase request) {
        if (this.apiKey != null) {
            Utils.addAuthTo(request, this.apiKey);
        }
    }

    static final class UserAgent {
        private final String value;

        private UserAgent(String value) {
            this.value = value;
        }

        static UserAgent of(MarquezClient.Version version) {
            return UserAgent.of("marquez-java/" + version.getValue());
        }

        static UserAgent of(String value) {
            return new UserAgent(value);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserAgent)) {
                return false;
            }
            UserAgent other = (UserAgent)o;
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MarquezHttp.UserAgent(value=" + this.getValue() + ")";
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }

    static final class HttpError {
        @Nullable
        private final Integer code;
        @Nullable
        private final String message;
        @Nullable
        private final String details;

        @JsonCreator
        HttpError(@Nullable Integer code, @Nullable String message, @Nullable String details) {
            this.code = code;
            this.message = message;
            this.details = details;
        }

        static HttpError of(HttpResponse response) throws IOException {
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            return HttpError.fromJson(json);
        }

        static HttpError fromJson(String json) {
            return Utils.fromJson(json, new TypeReference<HttpError>(){});
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpError)) {
                return false;
            }
            HttpError other = (HttpError)o;
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$details = this.getDetails();
            String other$details = other.getDetails();
            return !(this$details == null ? other$details != null : !this$details.equals(other$details));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $details = this.getDetails();
            result = result * 59 + ($details == null ? 43 : $details.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MarquezHttp.HttpError(code=" + this.getCode() + ", message=" + this.getMessage() + ", details=" + this.getDetails() + ")";
        }

        @Nullable
        @Generated
        public Integer getCode() {
            return this.code;
        }

        @Nullable
        @Generated
        public String getMessage() {
            return this.message;
        }

        @Nullable
        @Generated
        public String getDetails() {
            return this.details;
        }
    }
}

