/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.dto;

import cn.hutool.core.date.DateUtil;
import com.dtp.common.em.NotifyTypeEnum;
import java.util.concurrent.atomic.AtomicInteger;

public class AlarmInfo {
    private NotifyTypeEnum type;
    private String lastAlarmTime;
    private final AtomicInteger counter = new AtomicInteger(0);

    public void incCounter() {
        this.counter.incrementAndGet();
    }

    public void reset() {
        this.lastAlarmTime = DateUtil.now();
        this.counter.set(0);
    }

    public int getCount() {
        return this.counter.get();
    }

    AlarmInfo(NotifyTypeEnum type, String lastAlarmTime) {
        this.type = type;
        this.lastAlarmTime = lastAlarmTime;
    }

    public static AlarmInfoBuilder builder() {
        return new AlarmInfoBuilder();
    }

    public NotifyTypeEnum getType() {
        return this.type;
    }

    public String getLastAlarmTime() {
        return this.lastAlarmTime;
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public void setType(NotifyTypeEnum type) {
        this.type = type;
    }

    public void setLastAlarmTime(String lastAlarmTime) {
        this.lastAlarmTime = lastAlarmTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmInfo)) {
            return false;
        }
        AlarmInfo other = (AlarmInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NotifyTypeEnum this$type = this.getType();
        NotifyTypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$lastAlarmTime = this.getLastAlarmTime();
        String other$lastAlarmTime = other.getLastAlarmTime();
        if (this$lastAlarmTime == null ? other$lastAlarmTime != null : !this$lastAlarmTime.equals(other$lastAlarmTime)) {
            return false;
        }
        AtomicInteger this$counter = this.getCounter();
        AtomicInteger other$counter = other.getCounter();
        return !(this$counter == null ? other$counter != null : !this$counter.equals(other$counter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NotifyTypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $lastAlarmTime = this.getLastAlarmTime();
        result = result * 59 + ($lastAlarmTime == null ? 43 : $lastAlarmTime.hashCode());
        AtomicInteger $counter = this.getCounter();
        result = result * 59 + ($counter == null ? 43 : $counter.hashCode());
        return result;
    }

    public String toString() {
        return "AlarmInfo(type=" + (Object)((Object)this.getType()) + ", lastAlarmTime=" + this.getLastAlarmTime() + ", counter=" + this.getCounter() + ")";
    }

    public static class AlarmInfoBuilder {
        private NotifyTypeEnum type;
        private String lastAlarmTime;

        AlarmInfoBuilder() {
        }

        public AlarmInfoBuilder type(NotifyTypeEnum type) {
            this.type = type;
            return this;
        }

        public AlarmInfoBuilder lastAlarmTime(String lastAlarmTime) {
            this.lastAlarmTime = lastAlarmTime;
            return this;
        }

        public AlarmInfo build() {
            return new AlarmInfo(this.type, this.lastAlarmTime);
        }

        public String toString() {
            return "AlarmInfo.AlarmInfoBuilder(type=" + (Object)((Object)this.type) + ", lastAlarmTime=" + this.lastAlarmTime + ")";
        }
    }
}

