/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.config;

import com.dtp.common.constant.DynamicTpConst;
import com.dtp.common.dto.NotifyItem;
import com.dtp.common.em.QueueTypeEnum;
import com.dtp.common.em.RejectedTypeEnum;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ThreadPoolProperties {
    private String threadPoolName = "DefaultDynamicTp";
    private String executorType;
    private int corePoolSize = 1;
    private int maximumPoolSize = DynamicTpConst.AVAILABLE_PROCESSORS;
    private int queueCapacity = 1024;
    private String queueType = QueueTypeEnum.VARIABLE_LINKED_BLOCKING_QUEUE.getName();
    private boolean fair = false;
    private String rejectedHandlerType = RejectedTypeEnum.ABORT_POLICY.getName();
    private long keepAliveTime = 30L;
    private TimeUnit unit = TimeUnit.SECONDS;
    private boolean allowCoreThreadTimeOut = false;
    private String threadNamePrefix = "dynamic-tp";
    private List<NotifyItem> notifyItems;
    private boolean waitForTasksToCompleteOnShutdown = false;
    private int awaitTerminationSeconds = 0;
    private boolean preStartAllCoreThreads = false;
    private long runTimeout = 0L;
    private long queueTimeout = 0L;
    private Set<String> taskWrapperNames;

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public String getExecutorType() {
        return this.executorType;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public String getQueueType() {
        return this.queueType;
    }

    public boolean isFair() {
        return this.fair;
    }

    public String getRejectedHandlerType() {
        return this.rejectedHandlerType;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public boolean isAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public List<NotifyItem> getNotifyItems() {
        return this.notifyItems;
    }

    public boolean isWaitForTasksToCompleteOnShutdown() {
        return this.waitForTasksToCompleteOnShutdown;
    }

    public int getAwaitTerminationSeconds() {
        return this.awaitTerminationSeconds;
    }

    public boolean isPreStartAllCoreThreads() {
        return this.preStartAllCoreThreads;
    }

    public long getRunTimeout() {
        return this.runTimeout;
    }

    public long getQueueTimeout() {
        return this.queueTimeout;
    }

    public Set<String> getTaskWrapperNames() {
        return this.taskWrapperNames;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public void setExecutorType(String executorType) {
        this.executorType = executorType;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setQueueType(String queueType) {
        this.queueType = queueType;
    }

    public void setFair(boolean fair) {
        this.fair = fair;
    }

    public void setRejectedHandlerType(String rejectedHandlerType) {
        this.rejectedHandlerType = rejectedHandlerType;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public void setNotifyItems(List<NotifyItem> notifyItems) {
        this.notifyItems = notifyItems;
    }

    public void setWaitForTasksToCompleteOnShutdown(boolean waitForTasksToCompleteOnShutdown) {
        this.waitForTasksToCompleteOnShutdown = waitForTasksToCompleteOnShutdown;
    }

    public void setAwaitTerminationSeconds(int awaitTerminationSeconds) {
        this.awaitTerminationSeconds = awaitTerminationSeconds;
    }

    public void setPreStartAllCoreThreads(boolean preStartAllCoreThreads) {
        this.preStartAllCoreThreads = preStartAllCoreThreads;
    }

    public void setRunTimeout(long runTimeout) {
        this.runTimeout = runTimeout;
    }

    public void setQueueTimeout(long queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public void setTaskWrapperNames(Set<String> taskWrapperNames) {
        this.taskWrapperNames = taskWrapperNames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolProperties)) {
            return false;
        }
        ThreadPoolProperties other = (ThreadPoolProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
            return false;
        }
        if (this.getQueueCapacity() != other.getQueueCapacity()) {
            return false;
        }
        if (this.isFair() != other.isFair()) {
            return false;
        }
        if (this.getKeepAliveTime() != other.getKeepAliveTime()) {
            return false;
        }
        if (this.isAllowCoreThreadTimeOut() != other.isAllowCoreThreadTimeOut()) {
            return false;
        }
        if (this.isWaitForTasksToCompleteOnShutdown() != other.isWaitForTasksToCompleteOnShutdown()) {
            return false;
        }
        if (this.getAwaitTerminationSeconds() != other.getAwaitTerminationSeconds()) {
            return false;
        }
        if (this.isPreStartAllCoreThreads() != other.isPreStartAllCoreThreads()) {
            return false;
        }
        if (this.getRunTimeout() != other.getRunTimeout()) {
            return false;
        }
        if (this.getQueueTimeout() != other.getQueueTimeout()) {
            return false;
        }
        String this$threadPoolName = this.getThreadPoolName();
        String other$threadPoolName = other.getThreadPoolName();
        if (this$threadPoolName == null ? other$threadPoolName != null : !this$threadPoolName.equals(other$threadPoolName)) {
            return false;
        }
        String this$executorType = this.getExecutorType();
        String other$executorType = other.getExecutorType();
        if (this$executorType == null ? other$executorType != null : !this$executorType.equals(other$executorType)) {
            return false;
        }
        String this$queueType = this.getQueueType();
        String other$queueType = other.getQueueType();
        if (this$queueType == null ? other$queueType != null : !this$queueType.equals(other$queueType)) {
            return false;
        }
        String this$rejectedHandlerType = this.getRejectedHandlerType();
        String other$rejectedHandlerType = other.getRejectedHandlerType();
        if (this$rejectedHandlerType == null ? other$rejectedHandlerType != null : !this$rejectedHandlerType.equals(other$rejectedHandlerType)) {
            return false;
        }
        TimeUnit this$unit = this.getUnit();
        TimeUnit other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit)) {
            return false;
        }
        String this$threadNamePrefix = this.getThreadNamePrefix();
        String other$threadNamePrefix = other.getThreadNamePrefix();
        if (this$threadNamePrefix == null ? other$threadNamePrefix != null : !this$threadNamePrefix.equals(other$threadNamePrefix)) {
            return false;
        }
        List<NotifyItem> this$notifyItems = this.getNotifyItems();
        List<NotifyItem> other$notifyItems = other.getNotifyItems();
        if (this$notifyItems == null ? other$notifyItems != null : !((Object)this$notifyItems).equals(other$notifyItems)) {
            return false;
        }
        Set<String> this$taskWrapperNames = this.getTaskWrapperNames();
        Set<String> other$taskWrapperNames = other.getTaskWrapperNames();
        return !(this$taskWrapperNames == null ? other$taskWrapperNames != null : !((Object)this$taskWrapperNames).equals(other$taskWrapperNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaximumPoolSize();
        result = result * 59 + this.getQueueCapacity();
        result = result * 59 + (this.isFair() ? 79 : 97);
        long $keepAliveTime = this.getKeepAliveTime();
        result = result * 59 + (int)($keepAliveTime >>> 32 ^ $keepAliveTime);
        result = result * 59 + (this.isAllowCoreThreadTimeOut() ? 79 : 97);
        result = result * 59 + (this.isWaitForTasksToCompleteOnShutdown() ? 79 : 97);
        result = result * 59 + this.getAwaitTerminationSeconds();
        result = result * 59 + (this.isPreStartAllCoreThreads() ? 79 : 97);
        long $runTimeout = this.getRunTimeout();
        result = result * 59 + (int)($runTimeout >>> 32 ^ $runTimeout);
        long $queueTimeout = this.getQueueTimeout();
        result = result * 59 + (int)($queueTimeout >>> 32 ^ $queueTimeout);
        String $threadPoolName = this.getThreadPoolName();
        result = result * 59 + ($threadPoolName == null ? 43 : $threadPoolName.hashCode());
        String $executorType = this.getExecutorType();
        result = result * 59 + ($executorType == null ? 43 : $executorType.hashCode());
        String $queueType = this.getQueueType();
        result = result * 59 + ($queueType == null ? 43 : $queueType.hashCode());
        String $rejectedHandlerType = this.getRejectedHandlerType();
        result = result * 59 + ($rejectedHandlerType == null ? 43 : $rejectedHandlerType.hashCode());
        TimeUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        String $threadNamePrefix = this.getThreadNamePrefix();
        result = result * 59 + ($threadNamePrefix == null ? 43 : $threadNamePrefix.hashCode());
        List<NotifyItem> $notifyItems = this.getNotifyItems();
        result = result * 59 + ($notifyItems == null ? 43 : ((Object)$notifyItems).hashCode());
        Set<String> $taskWrapperNames = this.getTaskWrapperNames();
        result = result * 59 + ($taskWrapperNames == null ? 43 : ((Object)$taskWrapperNames).hashCode());
        return result;
    }

    public String toString() {
        return "ThreadPoolProperties(threadPoolName=" + this.getThreadPoolName() + ", executorType=" + this.getExecutorType() + ", corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", queueCapacity=" + this.getQueueCapacity() + ", queueType=" + this.getQueueType() + ", fair=" + this.isFair() + ", rejectedHandlerType=" + this.getRejectedHandlerType() + ", keepAliveTime=" + this.getKeepAliveTime() + ", unit=" + (Object)((Object)this.getUnit()) + ", allowCoreThreadTimeOut=" + this.isAllowCoreThreadTimeOut() + ", threadNamePrefix=" + this.getThreadNamePrefix() + ", notifyItems=" + this.getNotifyItems() + ", waitForTasksToCompleteOnShutdown=" + this.isWaitForTasksToCompleteOnShutdown() + ", awaitTerminationSeconds=" + this.getAwaitTerminationSeconds() + ", preStartAllCoreThreads=" + this.isPreStartAllCoreThreads() + ", runTimeout=" + this.getRunTimeout() + ", queueTimeout=" + this.getQueueTimeout() + ", taskWrapperNames=" + this.getTaskWrapperNames() + ")";
    }
}

