/*
 * Decompiled with CFR 0.152.
 */
package io.github.kawamuray.wasmtime;

import io.github.kawamuray.wasmtime.Func;
import io.github.kawamuray.wasmtime.Global;
import io.github.kawamuray.wasmtime.Memory;
import io.github.kawamuray.wasmtime.Table;

public class Extern {
    public static final Extern UNKNOWN = new Extern(Type.UNKNOWN, null);
    private final Type type;
    private final Object value;

    public static Extern fromFunc(Func func) {
        return new Extern(Type.FUNC, func);
    }

    public static Extern fromMemory(Memory memory) {
        return new Extern(Type.MEMORY, memory);
    }

    public static Extern fromTable(Table table) {
        return new Extern(Type.TABLE, table);
    }

    public static Extern fromGlobal(Global table) {
        return new Extern(Type.GLOBAL, table);
    }

    private void ensureType(Type expected) {
        if (this.type != expected) {
            throw new RuntimeException(String.format("extern expected to have type %s but is actually %s", new Object[]{expected, this.type}));
        }
    }

    public Func func() {
        this.ensureType(Type.FUNC);
        return (Func)this.value;
    }

    public Global global() {
        this.ensureType(Type.GLOBAL);
        return (Global)this.value;
    }

    public Memory memory() {
        this.ensureType(Type.MEMORY);
        return (Memory)this.value;
    }

    public Table table() {
        this.ensureType(Type.TABLE);
        return (Table)this.value;
    }

    Extern(Type type, Object value) {
        this.type = type;
        this.value = value;
    }

    public Type type() {
        return this.type;
    }

    public static enum Type {
        UNKNOWN,
        FUNC,
        GLOBAL,
        TABLE,
        MEMORY;

    }
}

