/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.ContentTypes;
import groovyx.net.http.EmbeddedEncoder;
import groovyx.net.http.MultipartContent;
import groovyx.net.http.ToServer;
import groovyx.net.http.util.Misc;
import java.io.IOException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class ApacheEncoders {
    public static void multipart(ChainedHttpConfig config, ToServer ts) {
        try {
            ChainedHttpConfig.ChainedRequest request = config.getChainedRequest();
            Object body = request.actualBody();
            if (!(body instanceof MultipartContent)) {
                throw new IllegalArgumentException("Multipart body content must be MultipartContent.");
            }
            String contentType = request.actualContentType();
            if (!contentType.equals(ContentTypes.MULTIPART_FORMDATA.getAt(0)) && !contentType.equals(ContentTypes.MULTIPART_MIXED.getAt(0))) {
                throw new IllegalArgumentException("Multipart body content must be multipart/form-data.");
            }
            String boundary = Misc.randomString((int)10);
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().setBoundary(boundary);
            String boundaryContentType = "multipart/form-data; boundary=" + boundary;
            entityBuilder.setContentType(ContentType.parse((String)boundaryContentType));
            for (MultipartContent.MultipartPart mpe : ((MultipartContent)body).parts()) {
                if (mpe.getFileName() == null) {
                    entityBuilder.addTextBody(mpe.getFieldName(), (String)mpe.getContent());
                    continue;
                }
                byte[] encodedBytes = EmbeddedEncoder.encode((ChainedHttpConfig)config, (String)mpe.getContentType(), (Object)mpe.getContent());
                entityBuilder.addBinaryBody(mpe.getFieldName(), encodedBytes, ContentType.parse((String)mpe.getContentType()), mpe.getFileName());
            }
            request.setContentType(boundaryContentType);
            ts.toServer(entityBuilder.build().getContent());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

