/*
 * Decompiled with CFR 0.152.
 */
package application.context.states;

import application.context.ApplicationContext;
import application.context.annotation.Callback;
import application.context.annotation.Message;
import application.context.annotation.State;
import application.routing.Router;
import java.lang.reflect.Method;

public class StateReader {
    private StateReader() {
    }

    public static void read(Class clazz) {
        Router router = ApplicationContext.getComponent(Router.class);
        State classAnnotation = clazz.getAnnotation(State.class);
        int stateNumber = classAnnotation.value();
        boolean foundAnnotation = false;
        for (Method method : clazz.getDeclaredMethods()) {
            Message caseAnnotation = method.getAnnotation(Message.class);
            Callback callbackAnnotation = method.getAnnotation(Callback.class);
            if (caseAnnotation != null) {
                foundAnnotation = true;
                router.add(stateNumber, method.getName(), clazz, caseAnnotation.message());
            }
            if (callbackAnnotation == null) continue;
            foundAnnotation = true;
            router.addCallback(stateNumber, method.getName(), clazz, callbackAnnotation.command());
        }
        if (!foundAnnotation) {
            throw new NullPointerException("No case/callback method specified in " + clazz);
        }
    }
}

