/*
 * Decompiled with CFR 0.152.
 */
package application.context.scan;

import application.exception.PackageNameException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

public class Scanner {
    private Scanner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getAllFilesInPackage(String packageName) throws IOException, URISyntaxException {
        URI uri;
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            uri = Scanner.class.getResource("/" + packageName).toURI();
        }
        catch (NullPointerException e) {
            throw new PackageNameException("Package with name '" + packageName + "' not found or it is not a root package");
        }
        boolean runningFromJar = false;
        try (FileSystem fileSystem = null;){
            Path pathToProject;
            if (uri.getScheme().equals("jar")) {
                fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                pathToProject = fileSystem.getPath("/", packageName);
                runningFromJar = true;
            } else {
                pathToProject = Paths.get(uri);
            }
            try (Stream<Path> fileWalk = Scanner.createFileWalkStream(pathToProject);){
                int classFilesCount = 0;
                Iterator fileIterator = fileWalk.iterator();
                while (fileIterator.hasNext()) {
                    Path pathToFile = (Path)fileIterator.next();
                    if (!pathToFile.getFileName().toString().endsWith("class")) continue;
                    ++classFilesCount;
                    String fullyQualifiedName = runningFromJar ? Scanner.constructFQNForLoadingFromJar(pathToFile) : Scanner.constructFQNForLoadingFromFilesystem(pathToFile);
                    String className = Scanner.constructFileName(pathToFile);
                    result.put(className, fullyQualifiedName);
                }
                Scanner.printMessage(packageName, classFilesCount);
            }
        }
        return result;
    }

    private static Stream<Path> createFileWalkStream(Path path) throws IOException {
        return Files.walk(path, Integer.MAX_VALUE, new FileVisitOption[0]);
    }

    private static String constructFQNForLoadingFromJar(Path path) {
        return path.toAbsolutePath().toString().substring(1).replace("\\", "/").split(".class")[0].replace("/", ".");
    }

    private static String constructFQNForLoadingFromFilesystem(Path path) {
        return path.toAbsolutePath().toString().replace("\\", "/").split("/classes/")[1].split(".class")[0].replace("/", ".");
    }

    private static String constructFileName(Path path) {
        return path.getFileName().toString().split(".class")[0];
    }

    private static void printMessage(String packageName, int classFilesCount) {
        System.out.printf("[INFO] %s File scan finished in %s package, found %d files%n", LocalDateTime.now().toString(), packageName, classFilesCount);
    }
}

