/*
 * Decompiled with CFR 0.152.
 */
package application.context.inject;

import application.context.ApplicationContext;
import application.context.annotation.Inject;
import application.context.annotation.UserServiceMarker;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

public class Injector {
    private Injector() {
    }

    public static void inject() throws IllegalAccessException {
        HashMap allComponents = new HashMap();
        allComponents.putAll(ApplicationContext.getSingletonComponents());
        allComponents.putAll(ApplicationContext.getPrototypeComponents());
        Object userService = ApplicationContext.getUserServiceComponent();
        allComponents.put(userService.getClass(), userService);
        Class<?> userServiceClass = userService.getClass();
        for (Map.Entry entry : allComponents.entrySet()) {
            Field[] fields;
            Class clazz = (Class)entry.getKey();
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (field.isAnnotationPresent(Inject.class)) {
                    Object injectingObject;
                    Inject annotation = field.getAnnotation(Inject.class);
                    if (field.getType() == userServiceClass) {
                        field.setAccessible(true);
                        injectingObject = userService;
                        field.set(entry.getValue(), injectingObject);
                        field.setAccessible(false);
                    } else {
                        injectingObject = ApplicationContext.getComponent(field.getType());
                        if (injectingObject == null) {
                            String qualifier = annotation.value();
                            if (qualifier.isEmpty()) {
                                throw new NullPointerException("Component for " + field.getType() + "not found in Application Context and no qualifier specified explicitly. Couldn't inject into " + clazz.getName());
                            }
                            injectingObject = ApplicationContext.getComponentByQualifier(qualifier);
                            if (injectingObject == null) {
                                throw new NullPointerException("Component for " + field.getType() + " or qualifier '" + qualifier + "' not found in Application Context. Couldn't inject into " + clazz.getName());
                            }
                        }
                        field.setAccessible(true);
                        field.set(entry.getValue(), injectingObject);
                        field.setAccessible(false);
                    }
                }
                if (!field.isAnnotationPresent(UserServiceMarker.class)) continue;
                field.setAccessible(true);
                Object injectingObject = userService;
                field.set(entry.getValue(), injectingObject);
                field.setAccessible(false);
            }
        }
        Injector.printMessage();
    }

    private static void printMessage() {
        System.out.printf("[INFO] %s Dependency injection successful%n", LocalDateTime.now().toString());
    }
}

