/*
 * Decompiled with CFR 0.152.
 */
package application.context.filter;

import application.context.ApplicationContext;
import application.context.annotation.Filter;
import application.context.filter.FilterAdapter;
import application.exception.FilterException;
import java.util.ArrayList;
import java.util.List;
import org.telegram.telegrambots.meta.api.objects.Update;

public class FilterContext {
    private static List<Class> filters = new ArrayList<Class>();

    private FilterContext() {
    }

    public static void addFilter(Class filterClass) {
        int filterOrder = filterClass.getDeclaredAnnotation(Filter.class).order();
        filters.add(filterOrder, filterClass);
    }

    public static boolean filter(Update update) {
        try {
            for (Class filter : filters) {
                boolean enabled = filter.getDeclaredAnnotation(Filter.class).enabled();
                if (!enabled) continue;
                FilterAdapter filterInstance = (FilterAdapter)ApplicationContext.getComponent(filter);
                update = filterInstance.filter(update);
            }
        }
        catch (FilterException e) {
            return false;
        }
        return true;
    }
}

