/*
 * Decompiled with CFR 0.152.
 */
package application.context.async;

import application.context.async.AsyncInvoker;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class AsyncContext {
    private static List<Class> asyncClasses = new ArrayList<Class>();

    private AsyncContext() {
    }

    public static void addAsync(Class asyncClass) {
        asyncClasses.add(asyncClass);
    }

    public static void runAsync() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (asyncClasses.isEmpty()) {
            return;
        }
        AsyncContext.invokeAsyncMethods();
        AsyncContext.printMessage();
    }

    private static void invokeAsyncMethods() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (Class config : asyncClasses) {
            AsyncInvoker.invoke(config);
        }
    }

    private static void printMessage() {
        System.out.printf("[INFO] %s Async init finished, found %d async class(-es)%n", LocalDateTime.now().toString(), asyncClasses.size());
    }
}

