/*
 * Decompiled with CFR 0.152.
 */
package application.context;

import application.context.async.AsyncContext;
import application.context.inject.Injector;
import application.context.reader.AnnotationReader;
import application.context.reader.PropertyReader;
import application.context.scan.Scanner;
import application.context.states.StateContext;
import application.exception.PackageNameException;
import application.logo.LogoPrinter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ApplicationContext {
    protected static HashMap<Class, Object> singletonComponents = new HashMap();
    protected static HashMap<Class, Object> prototypeComponents = new HashMap();
    protected static Class userServiceClass;
    protected static Object userServiceObject;
    private static int CURRENT_USER_ID;
    private static final String CORE_PACKAGE_NAME = "application";

    private ApplicationContext() {
    }

    protected static void init(String path) throws IOException {
        try {
            ApplicationContext.printLogo();
            ApplicationContext.printWarningMessage();
            ApplicationContext.loadProperties();
            String rootPackageName = ApplicationContext.getRootPackageName();
            if (rootPackageName == null || rootPackageName.isEmpty()) {
                throw new PackageNameException("Root package shouldn't be null or empty. Please encapsulate your project in a separate package");
            }
            Map<String, String> coreFiles = ApplicationContext.getAllFilesInCorePackage();
            Map<String, String> projectFiles = Scanner.getAllFilesInPackage(rootPackageName);
            ApplicationContext.combineFileMaps(coreFiles, projectFiles);
            ApplicationContext.performAnnotationReadingAmongGivenFiles(coreFiles);
            ApplicationContext.injectDependencies();
            ApplicationContext.initializeCasesContext();
            ApplicationContext.startAsynchronousCode();
        }
        catch (Exception e) {
            e.printStackTrace();
            ApplicationContext.destroy();
        }
        System.out.printf("[INFO] %s Application context initialization finished with %d singleton classes and %d prototype(-s)%n", LocalDateTime.now().toString(), singletonComponents.size(), prototypeComponents.size());
    }

    private static void combineFileMaps(Map<String, String> firstMap, Map<String, String> secondMap) {
        firstMap.putAll(secondMap);
    }

    private static void printLogo() throws FileNotFoundException {
        LogoPrinter.printLogo();
    }

    private static void printWarningMessage() {
        System.out.printf("[WARNING] It is not recommended to create package '%s' as it might interfere with frameworks's core package '%s'%n", CORE_PACKAGE_NAME, CORE_PACKAGE_NAME);
    }

    private static void loadProperties() {
        PropertyReader.load();
    }

    private static String getRootPackageName() {
        return PropertyReader.getProperty("rootPackage");
    }

    private static Map<String, String> getAllFilesInCorePackage() throws IOException, URISyntaxException {
        return Scanner.getAllFilesInPackage(CORE_PACKAGE_NAME);
    }

    private static void performAnnotationReadingAmongGivenFiles(Map<String, String> files) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        AnnotationReader.process(files);
    }

    private static void injectDependencies() throws IllegalAccessException {
        Injector.inject();
    }

    private static void initializeCasesContext() {
        StateContext.init();
    }

    private static void startAsynchronousCode() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        AsyncContext.runAsync();
    }

    protected static void destroy() {
        System.out.println("Destroyed");
        System.exit(1);
    }

    public static void setUserService(Class clazz) {
        userServiceClass = clazz;
    }

    public static Object getUserServiceComponent() {
        try {
            if (userServiceObject == null) {
                userServiceObject = userServiceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return userServiceObject;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No UserService class found");
        }
    }

    public static HashMap<Class, Object> getSingletonComponents() {
        return singletonComponents;
    }

    public static HashMap<Class, Object> getPrototypeComponents() {
        return prototypeComponents;
    }

    public static void putIntoSingletonContext(Object object) {
        singletonComponents.put(object.getClass(), object);
    }

    public static Object getSingletonComponent(Class instanceClass) {
        return singletonComponents.get(instanceClass);
    }

    public static void putIntoPrototypeContext(Object object) {
        prototypeComponents.put(object.getClass(), object);
    }

    public static Object getPrototypeComponent(Class instanceClass) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (!prototypeComponents.containsKey(instanceClass)) {
            throw new NullPointerException("Class not found in prototype context");
        }
        return instanceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static <T> T getComponent(Class<T> clazz) {
        if (singletonComponents.get(clazz) != null) {
            return (T)singletonComponents.get(clazz);
        }
        return (T)prototypeComponents.get(clazz);
    }

    public static int getUserState(int userid) {
        try {
            return (Integer)userServiceClass.getDeclaredMethod("getUserState", Integer.TYPE).invoke(userServiceObject, userid);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("No method getUserState(userid) specified in a class marked with @UserServiceMarker");
        }
    }

    public static int getCurrentUserState() {
        return ApplicationContext.getUserState(ApplicationContext.getCurrentUserId());
    }

    public static void setUserState(int userid, int state) {
        try {
            userServiceClass.getDeclaredMethod("setUserState", Integer.TYPE, Integer.TYPE).invoke(userServiceObject, userid, state);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("No method setUserState(userid, state) specified in a class marked with @UserServiceMarker");
        }
    }

    public static int getCurrentUserId() {
        return CURRENT_USER_ID;
    }

    public static void setCurrentUserId(int userid) {
        CURRENT_USER_ID = userid;
    }

    public static Object getComponentByQualifier(String qualifier) {
        Optional<Object> component = singletonComponents.entrySet().stream().filter(entry -> ((Class)entry.getKey()).getSimpleName().equalsIgnoreCase(qualifier)).map(entry -> entry.getValue()).findFirst();
        return component.isPresent() ? component.get() : null;
    }
}

