/*
 * Decompiled with CFR 0.152.
 */
package application.boilerplate;

import application.boilerplate.BotControllerBoilerplate;
import application.boilerplate.dto.Button;
import application.boilerplate.dto.InlineButton;
import application.context.ApplicationContext;
import application.context.annotation.Component;
import application.context.annotation.Inject;
import application.context.annotation.Prototype;
import application.exception.IllegalClassStateException;
import java.util.ArrayList;
import java.util.List;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButton;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardRow;

@Component
@Prototype
public class MessageSender {
    @Inject
    private BotControllerBoilerplate controller = ApplicationContext.getComponent(BotControllerBoilerplate.class);
    private SendMessage message = new SendMessage();
    private List<Button> buttons;

    public void setText(String text) {
        this.message.setText(text);
    }

    public void setChatId(int userid) {
        this.message.setChatId(Long.valueOf(userid));
    }

    public void sendMessage() {
        if (this.message.getText().isEmpty()) {
            throw new IllegalClassStateException("Message can't be sent if its text is empty. Use MessageSender#setText() before");
        }
        if (this.message.getChatId() == null || this.message.getChatId().isEmpty()) {
            throw new IllegalClassStateException("Message can't be sent if its chatId is empty. Use MessageSender#setChatId() before");
        }
        this.controller.sendMessage(this.message);
        this.buttons = null;
        this.message = new SendMessage();
    }

    public void setButtons(List<Button> buttons) {
        this.buttons = buttons;
        this.setButtons();
    }

    public void setButtons(List<Button> buttons, int columnCount) {
        this.buttons = buttons;
        this.setButtonsWhithColumnCount(columnCount);
    }

    private void setButtons() {
        if (this.buttons == null || this.buttons.isEmpty()) {
            throw new IllegalClassStateException("Butttons can't be set if texts are not set. Use MessageSender#setTexts() before");
        }
        this.setButtonsWhithColumnCount(2);
    }

    public void setButtonsWhithColumnCount(int columnCount) {
        if (this.buttons == null || this.buttons.isEmpty()) {
            throw new IllegalClassStateException("Butttons can't be set if texts are not set. Use MessageSender#setTexts() before");
        }
        this.setSpecialButtons(columnCount);
    }

    public void setSpecialButtons(int columnCount) {
        ReplyKeyboardMarkup replyKeyboardMarkup = new ReplyKeyboardMarkup();
        replyKeyboardMarkup.setSelective(Boolean.valueOf(true));
        replyKeyboardMarkup.setResizeKeyboard(Boolean.valueOf(true));
        replyKeyboardMarkup.setOneTimeKeyboard(Boolean.valueOf(false));
        int rowsCount = (int)Math.round((double)this.buttons.size() / (double)columnCount);
        ArrayList<KeyboardRow> keyboard = new ArrayList<KeyboardRow>(rowsCount);
        int buttonNum = 0;
        int totalButtons = this.buttons.size();
        for (int i = 0; i < rowsCount; ++i) {
            KeyboardRow row = new KeyboardRow();
            int iter = 0;
            for (int j = buttonNum; j < totalButtons; ++j) {
                Button button = this.buttons.get(buttonNum);
                KeyboardButton btn = new KeyboardButton(button.getText());
                if (button.isSetAsContactButton()) {
                    btn.setRequestContact(Boolean.valueOf(true));
                }
                if (button.isSetAsLocationButton()) {
                    btn.setRequestLocation(Boolean.valueOf(true));
                }
                row.add((Object)btn);
                ++buttonNum;
                if (iter == 1) break;
                ++iter;
            }
            keyboard.add(row);
        }
        replyKeyboardMarkup.setKeyboard(keyboard);
        this.message.setReplyMarkup((ReplyKeyboard)replyKeyboardMarkup);
    }

    public void setInlineButtons(List<InlineButton> buttons) {
        if (buttons == null || buttons.isEmpty()) {
            throw new IllegalClassStateException("Inline buttons can't be set if the list is null or empty");
        }
        InlineKeyboardMarkup inlineKeyboardMarkup = new InlineKeyboardMarkup();
        ArrayList rowList = new ArrayList();
        int i = 0;
        while ((long)i < Math.round((double)buttons.size() / 2.0)) {
            ArrayList<InlineKeyboardButton> keyboardButtonsRow1 = new ArrayList<InlineKeyboardButton>();
            try {
                InlineKeyboardButton inlineKeyboardButton1 = new InlineKeyboardButton();
                inlineKeyboardButton1.setText(buttons.get(i * 2).getText());
                inlineKeyboardButton1.setCallbackData(buttons.get(i * 2).getCommand());
                try {
                    inlineKeyboardButton1.setUrl(buttons.get(i * 2).getUrl().orElseThrow(() -> new NullPointerException()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                keyboardButtonsRow1.add(inlineKeyboardButton1);
            }
            catch (Exception inlineKeyboardButton1) {
                // empty catch block
            }
            try {
                InlineKeyboardButton inlineKeyboardButton2 = new InlineKeyboardButton();
                inlineKeyboardButton2.setText(buttons.get(i * 2 + 1).getText());
                inlineKeyboardButton2.setCallbackData(buttons.get(i * 2 + 1).getCommand());
                try {
                    inlineKeyboardButton2.setUrl(buttons.get(i * 2 + 1).getUrl().orElseThrow(() -> new NullPointerException()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                keyboardButtonsRow1.add(inlineKeyboardButton2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rowList.add(keyboardButtonsRow1);
            ++i;
        }
        inlineKeyboardMarkup.setKeyboard(rowList);
        this.message.setReplyMarkup((ReplyKeyboard)inlineKeyboardMarkup);
    }
}

