/*
 * Decompiled with CFR 0.152.
 */
package application.boilerplate;

import application.boilerplate.BotControllerBoilerplate;
import application.boilerplate.dto.InlineButton;
import application.context.ApplicationContext;
import application.context.annotation.Component;
import application.context.annotation.Inject;
import application.context.annotation.Prototype;
import application.exception.IllegalClassStateException;
import java.util.ArrayList;
import java.util.List;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.EditMessageText;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;

@Component
@Prototype
public class MessageEditor {
    @Inject
    private BotControllerBoilerplate controller = ApplicationContext.getComponent(BotControllerBoilerplate.class);
    private EditMessageText message = new EditMessageText();

    public void setText(String text) {
        this.message.setText(text);
    }

    public void setMessageId(int id) {
        this.message.setMessageId(Integer.valueOf(id));
    }

    public void setChatId(int userid) {
        this.message.setChatId(Long.valueOf(userid));
    }

    public void clearInlineButtons() {
        this.message.setReplyMarkup(null);
    }

    public void editMessage() {
        if (this.message.getText() == null || this.message.getText().isEmpty()) {
            throw new IllegalClassStateException("Message can't be sent if its text is null or empty. Use MessageSender#setText() before");
        }
        if (this.message.getChatId() == null || this.message.getChatId().isEmpty()) {
            throw new IllegalClassStateException("Message can't be sent if its chatId is empty. Use MessageSender#setChatId() before");
        }
        if (this.message.getMessageId() == null) {
            throw new IllegalClassStateException("Message can't be sent if its messageId is empty. Use MessageSender#setMessageId() before");
        }
        this.controller.editMessage(this.message);
        this.message = new EditMessageText();
    }

    public void setInlineButtons(List<InlineButton> buttons) {
        if (buttons == null || buttons.isEmpty()) {
            throw new IllegalClassStateException("Inline buttons can't be set if the list is null or empty");
        }
        InlineKeyboardMarkup inlineKeyboardMarkup = new InlineKeyboardMarkup();
        ArrayList rowList = new ArrayList();
        int i = 0;
        while ((long)i < Math.round((double)buttons.size() / 2.0)) {
            ArrayList<InlineKeyboardButton> keyboardButtonsRow1 = new ArrayList<InlineKeyboardButton>();
            try {
                InlineKeyboardButton inlineKeyboardButton1 = new InlineKeyboardButton();
                inlineKeyboardButton1.setText(buttons.get(i * 2).getText());
                inlineKeyboardButton1.setCallbackData(buttons.get(i * 2).getCommand());
                try {
                    inlineKeyboardButton1.setUrl(buttons.get(i * 2).getUrl().orElseThrow(() -> new NullPointerException()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                keyboardButtonsRow1.add(inlineKeyboardButton1);
            }
            catch (Exception inlineKeyboardButton1) {
                // empty catch block
            }
            try {
                InlineKeyboardButton inlineKeyboardButton2 = new InlineKeyboardButton();
                inlineKeyboardButton2.setText(buttons.get(i * 2 + 1).getText());
                inlineKeyboardButton2.setCallbackData(buttons.get(i * 2 + 1).getCommand());
                try {
                    inlineKeyboardButton2.setUrl(buttons.get(i * 2 + 1).getUrl().orElseThrow(() -> new NullPointerException()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                keyboardButtonsRow1.add(inlineKeyboardButton2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rowList.add(keyboardButtonsRow1);
            ++i;
        }
        inlineKeyboardMarkup.setKeyboard(rowList);
        this.message.setReplyMarkup(inlineKeyboardMarkup);
    }
}

