/*
 * Decompiled with CFR 0.152.
 */
package application.boilerplate;

import application.boilerplate.BotControllerBoilerplate;
import application.context.ApplicationContext;
import application.context.annotation.Component;
import application.context.annotation.Inject;
import application.context.annotation.Prototype;
import application.exception.IllegalClassStateException;
import org.telegram.telegrambots.meta.api.methods.send.SendDocument;
import org.telegram.telegrambots.meta.api.objects.InputFile;

@Component
@Prototype
public class DocumentSender {
    @Inject
    private BotControllerBoilerplate controller = ApplicationContext.getComponent(BotControllerBoilerplate.class);
    private SendDocument document = new SendDocument();

    public void setFile(InputFile file) {
        this.document.setDocument(new InputFile().setMedia(file.getNewMediaStream(), file.getMediaName()));
    }

    public void setChatId(int userid) {
        this.document.setChatId(Long.valueOf(userid));
    }

    public void sendDocument() {
        if (this.document.getDocument() == null) {
            throw new IllegalClassStateException("Document can't be sent if its document is not set. Use DocumentSender#setDocument() before");
        }
        if (this.document.getChatId() == null || this.document.getChatId().isEmpty()) {
            throw new IllegalClassStateException("Document can't be sent if its chatId is not set. Use DocumentSender#setDocument() before");
        }
        this.controller.sendDocument(this.document);
        this.document = new SendDocument();
    }
}

