/*
 * Decompiled with CFR 0.152.
 */
package application.boilerplate;

import application.context.ApplicationContext;
import application.context.annotation.Component;
import application.context.annotation.Inject;
import application.context.filter.FilterContext;
import application.context.reader.PropertyReader;
import application.exception.ApplicationStartException;
import application.exception.FileLoadException;
import application.routing.Router;
import application.session.SessionManager;
import java.io.File;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.GetFile;
import org.telegram.telegrambots.meta.api.methods.send.SendDocument;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.DeleteMessage;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.EditMessageText;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

@Component
public class BotControllerBoilerplate
extends TelegramLongPollingBot {
    @Inject
    private Router router;
    @Inject
    SessionManager sessionManager;
    private String token = PropertyReader.getProperty("bot.token");
    private String username = PropertyReader.getProperty("bot.username");

    public void onUpdateReceived(Update update) {
        try {
            int userid = -1;
            userid = update.hasCallbackQuery() ? this.getUserIdFromCallback(update) : this.getUserIdFromMessage(update);
            if (userid == -1) {
                throw new ApplicationStartException("User Id could not be obtained while receiving the update");
            }
            this.setCurrentUserId(userid);
            this.loadSessionForUser(userid);
            if (!FilterContext.filter(update)) {
                return;
            }
            int stateNumber = ApplicationContext.getCurrentUserState();
            if (update.hasCallbackQuery()) {
                String command = update.getCallbackQuery().getData();
                this.router.routeCallback(update, stateNumber, command);
            } else {
                String message = update.getMessage().getText();
                this.router.route(update, stateNumber, message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setCurrentUserId(int userid) {
        ApplicationContext.setCurrentUserId(userid);
    }

    private int getCurrentUserId() {
        return ApplicationContext.getCurrentUserId();
    }

    private int getUserState(int userid) {
        return ApplicationContext.getUserState(userid);
    }

    private void loadSessionForUser(int userid) {
        this.sessionManager.load(userid);
    }

    private int getUserIdFromCallback(Update update) {
        return update.getCallbackQuery().getFrom().getId();
    }

    private int getUserIdFromMessage(Update update) {
        return update.getMessage().getFrom().getId();
    }

    public String getBotUsername() {
        return this.username;
    }

    public String getBotToken() {
        return this.token;
    }

    protected void sendMessage(SendMessage sendMessage) {
        try {
            this.execute((BotApiMethod)sendMessage);
        }
        catch (TelegramApiException e) {
            e.printStackTrace();
        }
    }

    protected void editMessage(EditMessageText editMessage) {
        try {
            this.execute((BotApiMethod)editMessage);
        }
        catch (TelegramApiException e) {
            e.printStackTrace();
        }
    }

    protected void deleteMessage(DeleteMessage deleteMessage) {
        try {
            this.execute((BotApiMethod)deleteMessage);
        }
        catch (TelegramApiException e) {
            e.printStackTrace();
        }
    }

    protected void sendDocument(SendDocument sendDocument) {
        try {
            this.execute(sendDocument);
        }
        catch (TelegramApiException e) {
            e.printStackTrace();
        }
    }

    protected File loadDocument(GetFile getFile) {
        try {
            String filePath = ((org.telegram.telegrambots.meta.api.objects.File)this.execute((BotApiMethod)getFile)).getFilePath();
            return this.downloadFile(filePath);
        }
        catch (TelegramApiException e) {
            throw new FileLoadException("Loading file encountered a problem. File couldn't be loaded");
        }
    }
}

