/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.server.impl;

import io.github.a2ap.core.model.Task;
import io.github.a2ap.core.server.TaskStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTaskStore
implements TaskStore {
    private static final Logger log = LoggerFactory.getLogger(InMemoryTaskStore.class);
    private final Map<String, Task> store = new ConcurrentHashMap<String, Task>();

    @Override
    public void save(Task task) {
        this.store.put(task.getId(), task);
    }

    @Override
    public Task load(String taskId) {
        log.debug("Get task status, Loading task with ID {}", (Object)taskId);
        if (taskId == null) {
            log.warn("task Id is null.");
            return null;
        }
        return this.store.get(taskId);
    }
}

