/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.server;

import io.github.a2ap.core.model.SendStreamingMessageResponse;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class EventQueue {
    private static final Logger log = LoggerFactory.getLogger(EventQueue.class);
    private final Sinks.Many<SendStreamingMessageResponse> sink;
    private final List<EventQueue> children = new CopyOnWriteArrayList<EventQueue>();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public EventQueue() {
        this.sink = Sinks.many().multicast().onBackpressureBuffer();
        log.debug("EventQueue initialized.");
    }

    public void enqueueEvent(SendStreamingMessageResponse event) {
        if (this.isClosed.get()) {
            log.warn("Queue is closed. Event will not be enqueued.");
            return;
        }
        log.debug("Enqueuing event of type: {}", (Object)event.getClass().getSimpleName());
        Sinks.EmitResult result = this.sink.tryEmitNext((Object)event);
        if (result.isFailure()) {
            log.warn("Failed to enqueue event: {}", (Object)result);
        }
        for (EventQueue child : this.children) {
            child.enqueueEvent(event);
        }
    }

    public Flux<SendStreamingMessageResponse> asFlux() {
        return this.sink.asFlux();
    }

    public EventQueue tap() {
        log.debug("Tapping EventQueue to create a child queue.");
        EventQueue childQueue = new EventQueue();
        this.children.add(childQueue);
        return childQueue;
    }

    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            log.debug("Closing EventQueue.");
            this.sink.tryEmitComplete();
            for (EventQueue child : this.children) {
                child.close();
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }
}

