/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.model.Part;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TextPart
extends Part {
    @JsonProperty(value="kind")
    private final String kind = "text";
    @JsonProperty(value="text")
    private String text;

    public TextPart() {
    }

    public TextPart(String text) {
        this.text = text;
    }

    @Override
    public String getKind() {
        return "text";
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextPart textPart = (TextPart)o;
        return Objects.equals(this.text, textPart.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash("text", this.text);
    }

    @Override
    public String toString() {
        return "TextPart{kind='text', text='" + this.text + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String text;

        private Builder() {
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public TextPart build() {
            return new TextPart(this.text);
        }
    }
}

