/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.model.Message;
import io.github.a2ap.core.model.TaskState;
import io.github.a2ap.core.model.TaskUpdate;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TaskStatus
implements TaskUpdate {
    public static final TaskStatus COMPLETED = TaskStatus.builder().state(TaskState.COMPLETED).build();
    public static final TaskStatus CANCELLED = TaskStatus.builder().state(TaskState.CANCELED).build();
    @JsonProperty(value="state")
    private TaskState state;
    @JsonProperty(value="message")
    private Message message;
    @JsonProperty(value="timestamp")
    private String timestamp;
    @JsonProperty(value="error")
    private String error;

    public TaskStatus() {
    }

    public TaskStatus(TaskState state, Message message, String timestamp, String error) {
        this.state = state;
        this.message = message;
        this.timestamp = timestamp;
        this.error = error;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TaskState getState() {
        return this.state;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskStatus that = (TaskStatus)o;
        return this.state == that.state && Objects.equals(this.message, that.message) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.message, this.timestamp, this.error});
    }

    public String toString() {
        return "TaskStatus{state=" + this.state + ", message=" + this.message + ", timestamp='" + this.timestamp + "', error='" + this.error + "'}";
    }

    public static class Builder {
        private TaskState state;
        private Message message;
        private String timestamp;
        private String error;

        private Builder() {
        }

        public Builder state(TaskState state) {
            this.state = state;
            return this;
        }

        public Builder message(Message message) {
            this.message = message;
            return this;
        }

        public Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder error(String error) {
            this.error = error;
            return this;
        }

        public TaskStatus build() {
            return new TaskStatus(this.state, this.message, this.timestamp, this.error);
        }
    }
}

