/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import java.util.Objects;

public class TaskQueryParams {
    private String taskId;
    private String sessionId;

    public TaskQueryParams() {
    }

    public TaskQueryParams(String taskId) {
        this.taskId = taskId;
    }

    public TaskQueryParams(String taskId, String sessionId) {
        this.taskId = taskId;
        this.sessionId = sessionId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskQueryParams that = (TaskQueryParams)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.sessionId, that.sessionId);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.sessionId);
    }

    public String toString() {
        return "TaskQueryParams{taskId='" + this.taskId + "', sessionId='" + this.sessionId + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String taskId;
        private String sessionId;

        private Builder() {
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public TaskQueryParams build() {
            return new TaskQueryParams(this.taskId, this.sessionId);
        }
    }
}

