/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.model.PushNotificationConfig;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TaskPushNotificationConfig
extends PushNotificationConfig {
    @JsonProperty(value="task_id")
    private String taskId;

    public TaskPushNotificationConfig() {
    }

    public TaskPushNotificationConfig(String url, String authToken, String taskId) {
        super(url, authToken);
        this.taskId = taskId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskPushNotificationConfig that = (TaskPushNotificationConfig)o;
        return Objects.equals(this.taskId, that.taskId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.taskId);
    }

    @Override
    public String toString() {
        return "TaskPushNotificationConfig{taskId='" + this.taskId + "', url='" + this.getUrl() + "', authToken='" + this.getAuthToken() + "'}";
    }

    public static Builder taskPushBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private String authToken;
        private String taskId;

        private Builder() {
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public TaskPushNotificationConfig build() {
            return new TaskPushNotificationConfig(this.url, this.authToken, this.taskId);
        }
    }
}

