/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.github.a2ap.core.model.Message;
import io.github.a2ap.core.model.Task;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TaskAndHistory {
    private Task task;
    private List<Message> history;

    public TaskAndHistory() {
    }

    public TaskAndHistory(Task task, List<Message> history) {
        this.task = task;
        this.history = history;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public List<Message> getHistory() {
        return this.history;
    }

    public void setHistory(List<Message> history) {
        this.history = history;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskAndHistory that = (TaskAndHistory)o;
        return Objects.equals(this.task, that.task) && Objects.equals(this.history, that.history);
    }

    public int hashCode() {
        return Objects.hash(this.task, this.history);
    }

    public String toString() {
        return "TaskAndHistory{task=" + this.task + ", history=" + this.history + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Task task;
        private List<Message> history;

        private Builder() {
        }

        public Builder task(Task task) {
            this.task = task;
            return this;
        }

        public Builder history(List<Message> history) {
            this.history = history;
            return this;
        }

        public TaskAndHistory build() {
            return new TaskAndHistory(this.task, this.history);
        }
    }
}

