/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.model.Artifact;
import io.github.a2ap.core.model.Message;
import io.github.a2ap.core.model.SendMessageResponse;
import io.github.a2ap.core.model.SendStreamingMessageResponse;
import io.github.a2ap.core.model.TaskStatus;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Task
implements SendMessageResponse,
SendStreamingMessageResponse {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="contextId")
    private String contextId;
    @JsonProperty(value="status")
    private TaskStatus status;
    @JsonProperty(value="artifacts")
    private List<Artifact> artifacts;
    @JsonProperty(value="history")
    private List<Message> history;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata;
    @JsonProperty(value="kind")
    private String kind = "task";

    public Task() {
    }

    public Task(String id, String contextId, TaskStatus status, List<Artifact> artifacts, List<Message> history, Map<String, Object> metadata) {
        this.id = id;
        this.contextId = contextId;
        this.status = status;
        this.artifacts = artifacts;
        this.history = history;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    public List<Message> getHistory() {
        return this.history;
    }

    public void setHistory(List<Message> history) {
        this.history = history;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        return Objects.equals(this.id, task.id) && Objects.equals(this.contextId, task.contextId) && Objects.equals(this.kind, task.kind) && Objects.equals(this.status, task.status) && Objects.equals(this.artifacts, task.artifacts) && Objects.equals(this.history, task.history) && Objects.equals(this.metadata, task.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.contextId, this.status, this.artifacts, this.history, this.metadata, this.kind);
    }

    public String toString() {
        return "Task{id='" + this.id + "', contextId='" + this.contextId + "', status=" + this.status + ", artifacts=" + this.artifacts + ", history=" + this.history + ", metadata=" + this.metadata + ", kind=" + this.kind + "}";
    }

    public static class Builder {
        private String id;
        private String contextId;
        private TaskStatus status;
        private List<Artifact> artifacts;
        private List<Message> history;
        private Map<String, Object> metadata;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder status(TaskStatus status) {
            this.status = status;
            return this;
        }

        public Builder artifacts(List<Artifact> artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public Builder history(List<Message> history) {
            this.history = history;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Task build() {
            return new Task(this.id, this.contextId, this.status, this.artifacts, this.history, this.metadata);
        }
    }
}

