/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PushNotificationConfig {
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="auth_token")
    private String authToken;

    public PushNotificationConfig() {
    }

    public PushNotificationConfig(String url, String authToken) {
        this.url = url;
        this.authToken = authToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushNotificationConfig that = (PushNotificationConfig)o;
        return Objects.equals(this.url, that.url) && Objects.equals(this.authToken, that.authToken);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.authToken);
    }

    public String toString() {
        return "PushNotificationConfig{url='" + this.url + "', authToken='" + this.authToken + "'}";
    }

    public static class Builder {
        private String url;
        private String authToken;

        private Builder() {
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public PushNotificationConfig build() {
            return new PushNotificationConfig(this.url, this.authToken);
        }
    }
}

