/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import io.github.a2ap.core.model.PushNotificationConfig;
import java.util.List;
import java.util.Objects;

public class MessageSendConfiguration {
    private List<String> acceptedOutputModes;
    private Integer historyLength;
    private PushNotificationConfig pushNotificationConfig;
    private Boolean blocking;

    public MessageSendConfiguration() {
    }

    public MessageSendConfiguration(List<String> acceptedOutputModes, Integer historyLength, PushNotificationConfig pushNotificationConfig, Boolean blocking) {
        this.acceptedOutputModes = acceptedOutputModes;
        this.historyLength = historyLength;
        this.pushNotificationConfig = pushNotificationConfig;
        this.blocking = blocking;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getAcceptedOutputModes() {
        return this.acceptedOutputModes;
    }

    public void setAcceptedOutputModes(List<String> acceptedOutputModes) {
        this.acceptedOutputModes = acceptedOutputModes;
    }

    public Integer getHistoryLength() {
        return this.historyLength;
    }

    public void setHistoryLength(Integer historyLength) {
        this.historyLength = historyLength;
    }

    public PushNotificationConfig getPushNotificationConfig() {
        return this.pushNotificationConfig;
    }

    public void setPushNotificationConfig(PushNotificationConfig pushNotificationConfig) {
        this.pushNotificationConfig = pushNotificationConfig;
    }

    public Boolean getBlocking() {
        return this.blocking;
    }

    public void setBlocking(Boolean blocking) {
        this.blocking = blocking;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageSendConfiguration that = (MessageSendConfiguration)o;
        return Objects.equals(this.acceptedOutputModes, that.acceptedOutputModes) && Objects.equals(this.historyLength, that.historyLength) && Objects.equals(this.pushNotificationConfig, that.pushNotificationConfig) && Objects.equals(this.blocking, that.blocking);
    }

    public int hashCode() {
        return Objects.hash(this.acceptedOutputModes, this.historyLength, this.pushNotificationConfig, this.blocking);
    }

    public String toString() {
        return "MessageSendConfiguration{acceptedOutputModes=" + this.acceptedOutputModes + ", historyLength=" + this.historyLength + ", pushNotificationConfig=" + this.pushNotificationConfig + ", blocking=" + this.blocking + "}";
    }

    public static class Builder {
        private List<String> acceptedOutputModes;
        private Integer historyLength;
        private PushNotificationConfig pushNotificationConfig;
        private Boolean blocking;

        private Builder() {
        }

        public Builder acceptedOutputModes(List<String> acceptedOutputModes) {
            this.acceptedOutputModes = acceptedOutputModes;
            return this;
        }

        public Builder historyLength(Integer historyLength) {
            this.historyLength = historyLength;
            return this;
        }

        public Builder pushNotificationConfig(PushNotificationConfig pushNotificationConfig) {
            this.pushNotificationConfig = pushNotificationConfig;
            return this;
        }

        public Builder blocking(Boolean blocking) {
            this.blocking = blocking;
            return this;
        }

        public MessageSendConfiguration build() {
            return new MessageSendConfiguration(this.acceptedOutputModes, this.historyLength, this.pushNotificationConfig, this.blocking);
        }
    }
}

