/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.model.FileContent;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FileWithBytes
extends FileContent {
    @JsonProperty(value="bytes")
    private String bytes;

    public FileWithBytes() {
    }

    public FileWithBytes(String bytes) {
        this.bytes = bytes;
    }

    public FileWithBytes(String name, String mimeType, String bytes) {
        super(name, mimeType);
        this.bytes = bytes;
    }

    public String getBytes() {
        return this.bytes;
    }

    public void setBytes(String bytes) {
        this.bytes = bytes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileWithBytes that = (FileWithBytes)o;
        return Objects.equals(this.bytes, that.bytes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bytes);
    }

    @Override
    public String toString() {
        return "FileWithBytes{bytes='" + (this.bytes != null ? "[BASE64]" : "null") + "', name='" + this.getName() + "', mimeType='" + this.getMimeType() + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String mimeType;
        private String bytes;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder bytes(String bytes) {
            this.bytes = bytes;
            return this;
        }

        public FileWithBytes build() {
            return new FileWithBytes(this.name, this.mimeType, this.bytes);
        }
    }
}

