/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.a2ap.core.model.Part;
import io.github.a2ap.core.model.TaskUpdate;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Artifact
implements TaskUpdate {
    @JsonProperty(value="artifactId")
    private String artifactId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="parts")
    private List<Part> parts;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata;

    public Artifact() {
    }

    public Artifact(String artifactId, String name, String description, List<Part> parts, Map<String, Object> metadata) {
        this.artifactId = artifactId;
        this.name = name;
        this.description = description;
        this.parts = parts;
        this.metadata = metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public void setParts(List<Part> parts) {
        this.parts = parts;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        return Objects.equals(this.artifactId, artifact.artifactId) && Objects.equals(this.name, artifact.name) && Objects.equals(this.description, artifact.description) && Objects.equals(this.parts, artifact.parts) && Objects.equals(this.metadata, artifact.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.name, this.description, this.parts, this.metadata);
    }

    public String toString() {
        return "Artifact{artifactId='" + this.artifactId + "', name='" + this.name + "', description='" + this.description + "', parts=" + this.parts + ", metadata=" + this.metadata + "}";
    }

    public static class Builder {
        private String artifactId;
        private String name;
        private String description;
        private List<Part> parts;
        private Map<String, Object> metadata;

        private Builder() {
        }

        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parts(List<Part> parts) {
            this.parts = parts;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Artifact build() {
            return new Artifact(this.artifactId, this.name, this.description, this.parts, this.metadata);
        }
    }
}

