/*
 * Decompiled with CFR 0.152.
 */
package io.github.a2ap.core.jsonrpc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JSONRPCError {
    @JsonProperty(value="code")
    private int code;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="data")
    private Object data;
    public static final int PARSE_ERROR = -32700;
    public static final int INVALID_REQUEST = -32600;
    public static final int METHOD_NOT_FOUND = -32601;
    public static final int INVALID_PARAMS = -32602;
    public static final int INTERNAL_ERROR = -32603;
    public static final int TASK_NOT_FOUND = -32000;
    public static final int AUTHENTICATION_FAILED = -32001;
    public static final int PUSH_NOTIFICATION_NOT_SUPPORTED = -32002;

    public JSONRPCError() {
    }

    public JSONRPCError(int code, String message, Object data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONRPCError that = (JSONRPCError)o;
        return this.code == that.code && Objects.equals(this.message, that.message) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message, this.data);
    }

    public String toString() {
        return "JSONRPCError{code=" + this.code + ", message='" + this.message + "', data=" + this.data + "}";
    }

    public static class Builder {
        private int code;
        private String message;
        private Object data;

        private Builder() {
        }

        public Builder code(int code) {
            this.code = code;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public JSONRPCError build() {
            return new JSONRPCError(this.code, this.message, this.data);
        }
    }
}

